/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.islands.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.gen.INoiseRandom;

public class WeightedList<T> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private int maxWeight = 1;
    private double totalWeight;

    public void addEntry(T object, double weight) {
        if (weight < 1.0) {
            return;
        }
        Entry entry = new Entry();
        entry.object = object;
        entry.weight = weight;
        this.totalWeight += weight;
        this.entries.add(entry);
        if (weight > (double)this.maxWeight) {
            this.maxWeight = (int)weight;
        }
    }

    public T getRandom(INoiseRandom rand) {
        int weight = rand.func_202696_a(this.maxWeight);
        int size = this.entries.size();
        int index = rand.func_202696_a(size);
        while (true) {
            Entry entry = this.entries.get(index);
            if (entry.weight > (double)weight) {
                return entry.object;
            }
            index = index >= size ? index + 1 : 0;
        }
    }

    public int size() {
        return this.entries.size();
    }

    public double get(T obj) {
        if (obj == null) {
            return -1.0;
        }
        Optional<Entry> entry = this.entries.stream().filter(e -> e.object == obj).findFirst();
        if (entry.isPresent()) {
            return entry.get().weight;
        }
        return -1.0;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    private class Entry {
        double weight;
        T object;

        private Entry() {
        }
    }
}

