/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.NativePatching;
import net.tslat.aoa3.capabilities.CapabilitiesManager;
import net.tslat.aoa3.client.Keybinds;
import net.tslat.aoa3.client.render.entity.EntityRenders;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoAArmour;
import net.tslat.aoa3.common.registration.AoABiomes;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoADispensables;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAEntitySpawns;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoALootModifiers;
import net.tslat.aoa3.common.registration.AoALootOperations;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoATileEntities;
import net.tslat.aoa3.common.registration.AoATools;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.ClientOperations;
import net.tslat.aoa3.util.WebUtil;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.worlds.nether.NetherGen;
import net.tslat.aoa3.worldgen.worlds.overworld.OverworldGen;

@Mod(value="aoa3")
public class AdventOfAscension {
    public static final String VERSION = "3.4.9";
    public static final String MOD_ID = "aoa3";

    public AdventOfAscension() {
        Logging.logStatusMessage("!~ Advent of Ascension v3.4.9 ~!");
        NativePatching.doEarlyPatches();
        this.modConstructTasks();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent ev) {
        CapabilitiesManager.registerCapabilities();
        NativePatching.doSetupPatches();
        AoAPackets.registerPackets();
        AoAEntitySpawns.registerEntitySpawns();
        StructuresHandler.registerStructures();
        AoABiomes.initBiomes();
        OverworldGen.init();
        NetherGen.init();
        AoADispensables.registerDispenseBehaviours();
        GlobalEvents.init();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent ev) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> AoABlocks::setCustomRenderTypes);
        Keybinds.registerKeybinds();
        AoATileEntities.registerRenderers();
        EntityRenders.registerEntityRenderers();
        EntityRenders.registerMiscEntityRenderers();
        EntityRenders.registerProjectileRenderers();
        AoAContainers.registerContainerScreens();
    }

    @SubscribeEvent
    public void serverStart(FMLServerStartingEvent ev) {
        AoACommand.registerSubCommands((CommandDispatcher<CommandSource>)ev.getCommandDispatcher());
        WebUtil.extraPlayerHalosFromWeb();
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent ev) {
        AoAScheduler.serverShutdownTasks();
    }

    private void modConstructTasks() {
        Logging.logStatusMessage("Performing mod construction tasks..");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AoABlocks.BLOCKS.register(modEventBus);
        AoAItems.ITEMS.register(modEventBus);
        AoABlocks.BLOCK_ITEMS.register(modEventBus);
        AoABlocks.FLUIDS.register(modEventBus);
        AoATileEntities.TILES.register(modEventBus);
        AoAWeapons.WEAPONS.register(modEventBus);
        AoASounds.SOUNDS.register(modEventBus);
        AoATools.TOOLS.register(modEventBus);
        AoAArmour.ARMOUR.register(modEventBus);
        AoAEnchantments.ENCHANTMENTS.register(modEventBus);
        AoAParticleTypes.PARTICLES.register(modEventBus);
        AoAContainers.CONTAINERS.register(modEventBus);
        AoARecipes.RECIPES.register(modEventBus);
        AoADimensions.MOD_DIMENSIONS.register(modEventBus);
        AoAWorldGen.SurfaceBuilders.SURFACE_BUILDERS.register(modEventBus);
        AoAWorldGen.Carvers.CARVERS.register(modEventBus);
        AoAWorldGen.Structures.STRUCTURES.register(modEventBus);
        AoAWorldGen.Features.FEATURES.register(modEventBus);
        AoAWorldGen.ChunkGeneratorTypes.CHUNKGEN_TYPES.register(modEventBus);
        AoABiomes.BIOMES.register(modEventBus);
        AoALootModifiers.LOOT_MODIFIERS.register(modEventBus);
        AoAEntities.initializeAllRegisters(modEventBus);
        AoAGameRules.registerGameRules();
        AoAAdvancementTriggers.registerTriggers();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, AoAConfig.SERVER_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AoAConfig.COMMON_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, AoAConfig.CLIENT_CONFIG_SPEC);
        DeferredWorkQueue.runLater(AoALootOperations::registerAll);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientOperations.registerResourceListeners();
        }
    }
}

