/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public class NativePatching {
    public static void doEarlyPatches() {
        NativePatching.patchLogStrippingMap();
        ((RangedAttribute)SharedMonsterAttributes.field_111267_a).field_111118_b = Double.MAX_VALUE;
    }

    public static void doSetupPatches() {
        NativePatching.patchInToolTypes();
    }

    private static void patchInToolTypes() {
        ToolType toolTypeSword = ToolType.get((String)"sword");
        ToolType toolTypeShears = ToolType.get((String)"shears");
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                int highestTier;
                ItemStack stack;
                HashMap toolTypes;
                if (item instanceof SwordItem) {
                    toolTypes = (HashMap)ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)item, (String)"toolClasses");
                    stack = new ItemStack((IItemProvider)item);
                    highestTier = 0;
                    for (ToolType type : item.getToolTypes(stack)) {
                        highestTier = Math.max(highestTier, item.getHarvestLevel(stack, type, null, null));
                    }
                    if (toolTypes.containsKey(toolTypeSword)) continue;
                    toolTypes.put(toolTypeSword, highestTier);
                    Logging.logMessage(Level.DEBUG, "Patched in sword tooltype for: " + item.getRegistryName().toString());
                    continue;
                }
                if (!(item instanceof ShearsItem)) continue;
                toolTypes = (HashMap)ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)item, (String)"toolClasses");
                stack = new ItemStack((IItemProvider)item);
                highestTier = 0;
                for (ToolType type : item.getToolTypes(stack)) {
                    highestTier = Math.max(highestTier, item.getHarvestLevel(stack, type, null, null));
                }
                if (toolTypes.containsKey(toolTypeShears)) continue;
                toolTypes.put(toolTypeShears, highestTier);
                Logging.logMessage(Level.DEBUG, "Patched in shears tooltype for: " + item.getRegistryName().toString());
            }
            catch (Exception ex) {
                Logging.logMessage(Level.ERROR, "Error while patching in tooltypes to a registered item, skipping this one.", ex);
            }
        }
    }

    private static void patchLogStrippingMap() {
        if (AxeItem.field_203176_a instanceof ImmutableMap) {
            AxeItem.field_203176_a = new HashMap(AxeItem.field_203176_a);
        }
    }
}

