/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraftforge.common.ToolType;

public class CustomToolsBlock
extends Block {
    @Nonnull
    private final ToolType[] validToolTypes;

    public CustomToolsBlock(Block.Properties properties, @Nonnull String primaryType, String ... secondaryTypes) {
        super(properties);
        this.validToolTypes = new ToolType[secondaryTypes.length + 1];
        this.validToolTypes[0] = ToolType.get((String)primaryType);
        for (int i = 0; i < secondaryTypes.length; ++i) {
            this.validToolTypes[i + 1] = ToolType.get((String)secondaryTypes[i]);
        }
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.validToolTypes[0];
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        for (ToolType validToolType : this.validToolTypes) {
            if (validToolType != tool) continue;
            return true;
        }
        return false;
    }
}

