/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.decoration.banner;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityUtil;

public class BannerBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<BannerType> TYPE = EnumProperty.func_177709_a((String)"type", BannerType.class);
    private static final VoxelShape MOUNTED_NORTH_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.15625));
    private static final VoxelShape MOUNTED_SOUTH_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.84375, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_EAST_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.84375, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_WEST_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.15625, 1.0, 1.0));
    private static final VoxelShape STANDING_NORTH_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.453125, 0.8125, 1.0, 0.609375));
    private static final VoxelShape STANDING_SOUTH_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.390625, 0.8125, 1.0, 0.546875));
    private static final VoxelShape STANDING_EAST_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.390625, 0.0, 0.1875, 0.546875, 1.0, 0.8125));
    private static final VoxelShape STANDING_WEST_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.453125, 0.0, 0.1875, 0.609375, 1.0, 0.8125));

    public BannerBlock() {
        super(BlockUtil.generateBlockProperties(Material.field_151594_q, MaterialColor.field_151668_h, 0.5f, 1.0f, SoundType.field_185854_g).func_226896_b_().func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)BannerType.MOUNTED))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.func_201670_d()) {
            if (state.func_177229_b(TYPE) == BannerType.MOUNTED) {
                world.func_175656_a(pos.func_177977_b(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).func_176223_P().func_206870_a(TYPE, (Comparable)((Object)BannerType.MOUNTED))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, state.func_177229_b((IProperty)HorizontalBlock.field_185512_D))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177977_b()).func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).func_176223_P().func_206870_a(TYPE, (Comparable)((Object)BannerType.STANDING))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, state.func_177229_b((IProperty)HorizontalBlock.field_185512_D))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204546_a)));
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (state.func_177229_b(TYPE) == BannerType.MOUNTED) {
            world.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
        } else {
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b(TYPE) == BannerType.MOUNTED) {
            Direction mountedFace = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
            return BannerBlock.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177972_a(mountedFace), (Direction)mountedFace.func_176734_d()) && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j();
        }
        return world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        switch (context.func_196000_l()) {
            case SOUTH: 
            case NORTH: 
            case WEST: 
            case EAST: {
                return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)BannerType.MOUNTED))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)BannerType.STANDING))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)EntityUtil.getDirectionFacing((Entity)context.func_195999_j(), true))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean mounted = state.func_177229_b(TYPE) == BannerType.MOUNTED;
        switch ((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)) {
            case SOUTH: {
                return mounted ? MOUNTED_SOUTH_SHAPE : STANDING_SOUTH_SHAPE;
            }
            case EAST: {
                return mounted ? MOUNTED_EAST_SHAPE : STANDING_EAST_SHAPE;
            }
            case WEST: {
                return mounted ? MOUNTED_WEST_SHAPE : STANDING_WEST_SHAPE;
            }
        }
        return mounted ? MOUNTED_NORTH_SHAPE : STANDING_NORTH_SHAPE;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_177229_b(TYPE) == BannerType.MOUNTED) {
            if (!world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D))).func_185904_a().func_76220_a()) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, HorizontalBlock.field_185512_D, BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public static enum BannerType implements IStringSerializable
    {
        MOUNTED("mounted"),
        STANDING("standing");

        private final String name;

        private BannerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

