/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.decoration.sapling;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.worldgen.trees.TreeGenerator;

public abstract class SaplingBlock
extends net.minecraft.block.SaplingBlock {
    private final boolean growsInDark;

    public SaplingBlock(MaterialColor mapColor, boolean growsInDark) {
        super(null, SaplingBlock.generateBlockProperties(mapColor));
        this.growsInDark = growsInDark;
    }

    private static Block.Properties generateBlockProperties(MaterialColor mapColor) {
        return Block.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)mapColor).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if ((this.growsInDark || world.func_201696_r(pos.func_177984_a()) >= 9) && rand.nextInt(7) == 0) {
            this.func_226942_a_(world, pos, state, rand);
        }
    }

    public void func_226942_a_(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)field_176479_b) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)field_176479_b), 4);
        } else if (ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)rand, (BlockPos)pos)) {
            this.getTree(world, pos, state, rand).generate((IWorld)world, rand, pos);
        }
    }

    protected abstract TreeGenerator getTree(ServerWorld var1, BlockPos var2, BlockState var3, Random var4);

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_200014_a_(state, worldIn, pos) || state.func_177230_c().func_203417_a(AoATags.Blocks.GRASS) || state.func_177230_c().func_203417_a(Tags.Blocks.DIRT);
    }
}

