/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.SkeletronEntity;
import net.tslat.aoa3.entity.mob.precasia.EliteSkeleHopperEntity;
import net.tslat.aoa3.entity.mob.precasia.EliteSkelePigEntity;
import net.tslat.aoa3.entity.mob.precasia.EliteSkelemanEntity;
import net.tslat.aoa3.entity.mob.precasia.SkeleElderEntity;
import net.tslat.aoa3.entity.mob.precasia.SkeleHopperEntity;
import net.tslat.aoa3.entity.mob.precasia.SkelePigEntity;
import net.tslat.aoa3.entity.mob.precasia.SkelemanEntity;
import net.tslat.aoa3.entity.mob.precasia.StrongSkeleHopperEntity;
import net.tslat.aoa3.entity.mob.precasia.StrongSkelePigEntity;
import net.tslat.aoa3.entity.mob.precasia.StrongSkelemanEntity;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class ArmyBlock
extends BossAltarBlock {
    public ArmyBlock() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_193574_Z, -1.0f, 1.0E9f).func_200944_c());
    }

    @Override
    protected boolean checkActivationConditions(PlayerEntity player, Hand hand, BlockState state, BlockPos pos) {
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(pos).func_186662_g(100.0), entity -> entity instanceof SkeleElderEntity || entity instanceof SkeletronEntity).size() == 0) {
            SkeleElderEntity skeleElder = new SkeleElderEntity(player.field_70170_p, pos, 0);
            skeleElder.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            player.field_70170_p.func_217376_c((Entity)skeleElder);
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.field_72995_K && rand.nextBoolean() && world.func_217357_a(SkeleElderEntity.class, new AxisAlignedBB(pos).func_186662_g(100.0)).isEmpty()) {
            world.func_217376_c((Entity)new SkeleElderEntity((World)world, pos, 0));
        }
    }

    @Override
    protected void doActivationEffect(PlayerEntity player, Hand hand, BlockState state, BlockPos blockPos) {
        ArmyBlock.spawnWave(player.field_70170_p, blockPos, 1);
        this.sendSpawnMessage(player, LocaleUtil.getLocaleMessage("message.mob.skeletalArmy.spawn", player.func_145748_c_().func_150254_d()), blockPos);
    }

    private static void spawnWaveEntities(World world, BlockPos armyBlockPos, Entity ... entities) {
        for (Entity entity : entities) {
            int posX = armyBlockPos.func_177958_n() - 17 + RandomUtil.randomNumberUpTo(23);
            int posZ = armyBlockPos.func_177952_p() - 11 + RandomUtil.randomNumberUpTo(19);
            BlockPos.Mutable checkPos = new BlockPos.Mutable(posX, armyBlockPos.func_177956_o(), posZ);
            while (checkPos.func_177956_o() < world.func_217301_I() && !world.func_175623_d((BlockPos)checkPos.func_189536_c(Direction.UP))) {
            }
            entity.func_70107_b((double)posX, (double)checkPos.func_177956_o(), (double)posZ);
            world.func_217376_c(entity);
        }
    }

    public static void spawnWave(World world, BlockPos blockPos, int wave) {
        if (!world.field_72995_K) {
            switch (wave) {
                case 1: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 2: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 3: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 4: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 5: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 6: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 7: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 8: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 9: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 10: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 11: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 12: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 13: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 14: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 15: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 16: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 17: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 18: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 19: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_PIG.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_HOPPER.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new SkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELEMAN.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 20: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 21: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 22: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 23: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 24: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 25: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 26: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 27: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 28: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 29: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 30: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 31: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 32: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 33: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 34: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 35: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 36: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_PIG.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELE_HOPPER.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new StrongSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STRONG_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 37: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 38: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkeleHopperEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_HOPPER.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new EliteSkelemanEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELEMAN.get()), world), new SkeleElderEntity(world, blockPos, wave)});
                    break;
                }
                case 39: {
                    world.func_217376_c((Entity)new SkeletronEntity(world, blockPos));
                    break;
                }
            }
        }
    }

    @Override
    protected Item getActivationItem() {
        return null;
    }
}

