/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class BossAltarBlock
extends Block {
    public BossAltarBlock(Block.Properties properties) {
        super(properties);
    }

    public BossAltarBlock(MaterialColor mapColour) {
        this(BlockUtil.generateBlockProperties(Material.field_151576_e, mapColour, -1.0f, 1.0E9f));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.getActivationItem() != null && heldItem.func_77973_b() != this.getActivationItem()) {
            return ActionResultType.PASS;
        }
        if (player instanceof ServerPlayerEntity && (this.getActivationItem() == null || heldItem.func_77973_b() == this.getActivationItem())) {
            if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.spawnBoss.difficultyFail", new Object[0]);
                return ActionResultType.FAIL;
            }
            if (this.checkActivationConditions(player, hand, state, pos)) {
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                this.doActivationEffect(player, hand, state, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    protected abstract Item getActivationItem();

    protected abstract void doActivationEffect(PlayerEntity var1, Hand var2, BlockState var3, BlockPos var4);

    protected boolean checkActivationConditions(PlayerEntity player, Hand hand, BlockState state, BlockPos pos) {
        return true;
    }

    protected void sendSpawnMessage(PlayerEntity player, TranslationTextComponent msg, BlockPos pos) {
        PlayerUtil.messageAllPlayersInRange((ITextComponent)msg, player.field_70170_p, pos, 50);
    }
}

