/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.boss.ClunkheadEntity;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ClunkheadAltar
extends BossAltarBlock {
    public ClunkheadAltar() {
        super(MaterialColor.field_151674_s);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.getActivationItem() != null && heldItem.func_77973_b() != this.getActivationItem()) {
            return ActionResultType.PASS;
        }
        if (player instanceof ServerPlayerEntity && (this.getActivationItem() == null || heldItem.func_77973_b() == this.getActivationItem())) {
            if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                PlayerUtil.notifyPlayer((ServerPlayerEntity)player, "message.feedback.spawnBoss.difficultyFail", new Object[0]);
                return ActionResultType.FAIL;
            }
            if (this.checkActivationConditions(player, hand, state, pos)) {
                if (!player.func_184812_l_()) {
                    ItemUtil.damageItem(heldItem, (LivingEntity)player, hand);
                }
                this.doActivationEffect(player, hand, state, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void doActivationEffect(PlayerEntity player, Hand hand, BlockState state, BlockPos blockPos) {
        ClunkheadEntity clunkhead = new ClunkheadEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CLUNKHEAD.get()), player.field_70170_p);
        clunkhead.func_70634_a(blockPos.func_177958_n() - 4, blockPos.func_177984_a().func_177956_o(), blockPos.func_177952_p() + 5);
        player.field_70170_p.func_217376_c((Entity)clunkhead);
        this.sendSpawnMessage(player, LocaleUtil.getLocaleMessage("message.mob.clunkhead.spawn", player.func_145748_c_().func_150254_d()), blockPos);
    }

    @Override
    protected Item getActivationItem() {
        return (Item)AoAItems.MEGA_RUNE_STONE.get();
    }
}

