/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.boss.BlueGuardianEntity;
import net.tslat.aoa3.entity.boss.GreenGuardianEntity;
import net.tslat.aoa3.entity.boss.RedGuardianEntity;
import net.tslat.aoa3.entity.boss.YellowGuardianEntity;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GuardianAltar
extends Block {
    public GuardianAltar() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151672_u, -1.0f, 1.0E9f));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AoAItems.VOLIANT_HEART.get()) {
            if (!world.field_72995_K) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (world.func_175651_c(pos.func_177972_a(direction), direction) != 0) continue;
                    return ActionResultType.FAIL;
                }
                if (!world.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - 15), (double)(pos.func_177956_o() - 15), (double)(pos.func_177952_p() - 15), (double)(pos.func_177958_n() + 15), (double)(pos.func_177956_o() + 15), (double)(pos.func_177952_p() + 15)), entity -> !entity.func_184222_aU()).isEmpty()) {
                    return ActionResultType.FAIL;
                }
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos checkPos = pos.func_177972_a(direction);
                    if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150488_af) continue;
                    this.breakWire(world, checkPos, 0);
                }
                BlueGuardianEntity blueGuardian = new BlueGuardianEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BLUE_GUARDIAN.get()), world);
                YellowGuardianEntity yellowGuardian = new YellowGuardianEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.YELLOW_GUARDIAN.get()), world);
                GreenGuardianEntity greenGuardian = new GreenGuardianEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.GREEN_GUARDIAN.get()), world);
                RedGuardianEntity redGuardian = new RedGuardianEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.RED_GUARDIAN.get()), world);
                blueGuardian.func_70012_b(pos.func_177958_n() + 8, pos.func_177956_o(), pos.func_177952_p() + 8, 0.0f, 0.0f);
                redGuardian.func_70012_b(pos.func_177958_n() - 8, pos.func_177956_o(), pos.func_177952_p() + 8, 0.0f, 0.0f);
                yellowGuardian.func_70012_b(pos.func_177958_n() - 8, pos.func_177956_o(), pos.func_177952_p() - 8, 0.0f, 0.0f);
                greenGuardian.func_70012_b(pos.func_177958_n() + 8, pos.func_177956_o(), pos.func_177952_p() - 8, 0.0f, 0.0f);
                world.func_217376_c((Entity)blueGuardian);
                world.func_217376_c((Entity)greenGuardian);
                world.func_217376_c((Entity)yellowGuardian);
                world.func_217376_c((Entity)redGuardian);
                blueGuardian.setGreenGuardian(greenGuardian);
                blueGuardian.setRedGuardian(redGuardian);
                blueGuardian.setYellowGuardian(yellowGuardian);
                greenGuardian.setBlueGuardian(blueGuardian);
                greenGuardian.setRedGuardian(redGuardian);
                greenGuardian.setYellowGuardian(yellowGuardian);
                redGuardian.setBlueGuardian(blueGuardian);
                redGuardian.setGreenGuardian(greenGuardian);
                redGuardian.setYellowGuardian(yellowGuardian);
                yellowGuardian.setBlueGuardian(blueGuardian);
                yellowGuardian.setGreenGuardian(greenGuardian);
                yellowGuardian.setRedGuardian(redGuardian);
                for (PlayerEntity pl : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - 25), (double)(pos.func_177956_o() - 25), (double)(pos.func_177952_p() - 25), (double)(pos.func_177958_n() + 26), (double)(pos.func_177956_o() + 26), (double)(pos.func_177952_p() + 26)))) {
                    pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.fourGuardians.spawn"));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private int breakWire(World world, BlockPos curPos, int currentCount) {
        world.func_217376_c((Entity)new ItemEntity(world, (double)curPos.func_177958_n(), (double)curPos.func_177956_o(), (double)curPos.func_177952_p(), new ItemStack((IItemProvider)Blocks.field_150488_af)));
        world.func_175656_a(curPos, Blocks.field_150350_a.func_176223_P());
        ++currentCount;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos newPos = curPos.func_177972_a(direction);
            if (world.func_180495_p(newPos).func_177230_c() == Blocks.field_150488_af) {
                currentCount = this.breakWire(world, newPos, currentCount);
            }
            if (currentCount < 20) continue;
            return currentCount;
        }
        return currentCount;
    }
}

