/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.block.functional.misc.DustopianLamp;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.KajarosEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PrimordialShrine
extends BossAltarBlock {
    public PrimordialShrine() {
        super(MaterialColor.field_193560_ab);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL && player instanceof ServerPlayerEntity) {
            PlayerUtil.getAdventPlayer((ServerPlayerEntity)player).sendThrottledChatMessage("message.feedback.spawnBoss.difficultyFail", new Object[0]);
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K && this.checkActivationConditions(player, hand, state, pos)) {
            this.doActivationEffect(player, hand, state, pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected boolean checkActivationConditions(PlayerEntity player, Hand hand, BlockState state, BlockPos pos) {
        BlockPos pos2 = pos.func_177981_b(1).func_177985_f(3).func_177964_d(5);
        BlockPos pos3 = pos.func_177981_b(1).func_177985_f(1).func_177964_d(4);
        BlockPos pos4 = pos.func_177981_b(3).func_177964_d(3).func_177965_g(1);
        BlockPos pos5 = pos.func_177981_b(5).func_177964_d(1).func_177965_g(1);
        return this.checkLamps(player.field_70170_p, pos.func_177981_b(1).func_177985_f(3).func_177964_d(5), pos2.func_177970_e(10), pos.func_177981_b(1).func_177985_f(1).func_177964_d(4), pos3.func_177970_e(8), pos.func_177981_b(3).func_177964_d(3).func_177965_g(1), pos4.func_177970_e(6), pos.func_177981_b(5).func_177964_d(1).func_177965_g(1), pos5.func_177970_e(2));
    }

    private boolean checkLamps(World world, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == AoABlocks.DUSTOPIAN_LAMP.get() && ((Boolean)state.func_177229_b((IProperty)DustopianLamp.LIT)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doActivationEffect(PlayerEntity player, Hand hand, BlockState state, BlockPos blockPos) {
        World world = player.field_70170_p;
        BlockState lampOff = (BlockState)((Block)AoABlocks.DUSTOPIAN_LAMP.get()).func_176223_P().func_206870_a((IProperty)DustopianLamp.LIT, (Comparable)Boolean.valueOf(false));
        switch (player.func_70681_au().nextInt(8)) {
            case 0: {
                world.func_175656_a(blockPos.func_177984_a().func_177985_f(3).func_177964_d(5), lampOff);
                break;
            }
            case 1: {
                world.func_175656_a(blockPos.func_177984_a().func_177985_f(3).func_177970_e(5), lampOff);
                break;
            }
            case 2: {
                world.func_175656_a(blockPos.func_177984_a().func_177976_e().func_177964_d(4), lampOff);
                break;
            }
            case 3: {
                world.func_175656_a(blockPos.func_177984_a().func_177976_e().func_177970_e(4), lampOff);
                break;
            }
            case 4: {
                world.func_175656_a(blockPos.func_177981_b(3).func_177964_d(3).func_177974_f(), lampOff);
                break;
            }
            case 5: {
                world.func_175656_a(blockPos.func_177981_b(3).func_177970_e(3).func_177974_f(), lampOff);
                break;
            }
            case 6: {
                world.func_175656_a(blockPos.func_177981_b(5).func_177978_c().func_177974_f(), lampOff);
                break;
            }
            case 7: {
                world.func_175656_a(blockPos.func_177981_b(5).func_177968_d().func_177974_f(), lampOff);
            }
        }
        KajarosEntity kajaros = new KajarosEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.KAJAROS.get()), player.field_70170_p);
        kajaros.func_70012_b(blockPos.func_177958_n(), blockPos.func_177956_o() + 3, blockPos.func_177952_p(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)kajaros);
        this.sendSpawnMessage(player, LocaleUtil.getLocaleMessage("message.mob.primordialFive.spawn", player.func_145748_c_().func_150254_d()), blockPos);
    }

    @Override
    protected Item getActivationItem() {
        return null;
    }
}

