/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.light;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraftforge.common.ToolType;

public class LightBlock
extends Block {
    public LightBlock(MaterialColor mapColour, Material material, float hardness, float resistance, int lightLevel) {
        this(mapColour, material, hardness, resistance, lightLevel, null, -1, null);
    }

    public LightBlock(MaterialColor mapColour, Material material, float hardness, float resistance, int lightLevel, @Nullable ToolType harvestTool) {
        this(mapColour, material, hardness, resistance, lightLevel, harvestTool, -1, null);
    }

    public LightBlock(MaterialColor mapColour, Material material, float hardness, float resistance, int lightLevel, @Nullable ToolType harvestTool, int harvestLevel) {
        this(mapColour, material, hardness, resistance, lightLevel, harvestTool, harvestLevel, null);
    }

    public LightBlock(MaterialColor mapColour, Material material, float hardness, float resistance, int lightLevel, @Nullable ToolType harvestTool, int harvestLevel, @Nullable SoundType soundType) {
        super(LightBlock.generateBlockProperties(material, mapColour, hardness, resistance, lightLevel, harvestTool, harvestLevel, soundType));
    }

    private static Block.Properties generateBlockProperties(Material material, MaterialColor mapColour, float hardness, float resistance, int lightLevel, @Nullable ToolType harvestTool, int harvestLevel, @Nullable SoundType soundType) {
        Block.Properties blockProperties = Block.Properties.func_200949_a((Material)material, (MaterialColor)mapColour);
        blockProperties.func_200948_a(hardness, resistance);
        blockProperties.harvestLevel(harvestLevel);
        blockProperties.func_200951_a(lightLevel);
        if (hardness == -1.0f && resistance == 1.0E9f) {
            blockProperties.func_222380_e();
        }
        if (harvestTool != null) {
            blockProperties.harvestTool(harvestTool);
        }
        if (soundType != null) {
            blockProperties.func_200947_a(soundType);
        } else if (material == null || material == Material.field_151576_e) {
            blockProperties.func_200947_a(SoundType.field_185851_d);
        } else if (material == Material.field_151575_d) {
            blockProperties.func_200947_a(SoundType.field_185848_a);
        } else if (material == Material.field_151578_c) {
            blockProperties.func_200947_a(SoundType.field_185849_b);
        } else if (material == Material.field_151592_s) {
            blockProperties.func_200947_a(SoundType.field_185853_f);
        }
        return blockProperties;
    }
}

