/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.item.misc.BlankRealmstone;
import net.tslat.aoa3.item.misc.Realmstone;
import net.tslat.aoa3.library.misc.AoAPortalFrame;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class CarvedRuneOfPower
extends Block {
    public CarvedRuneOfPower() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151646_E, 3.0f, 10.0f, SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            if (player.func_184586_b(hand).func_77973_b() instanceof Realmstone) {
                Realmstone realmstone = (Realmstone)player.func_184586_b(hand).func_77973_b();
                PortalBlock portalBlock = (PortalBlock)realmstone.getPortalBlock().get();
                AoAPortalFrame.PortalDirection direction = AoAPortalFrame.testFrameForActivation(world, pos, hit.func_216354_b(), portalBlock);
                if (direction == AoAPortalFrame.PortalDirection.EXISTING) {
                    player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.teleporterFrame.existing"));
                } else if (direction == AoAPortalFrame.PortalDirection.INVALID) {
                    player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.teleporterFrame.fail"));
                } else {
                    AoAPortalFrame.lightPortalFrame(world, pos, direction, portalBlock);
                    player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.teleporterFrame." + realmstone.getPortalMessageSuffix()));
                    if (realmstone.getActivationSound() != null) {
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)realmstone.getActivationSound().get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_184586_b(hand).func_77973_b() instanceof BlankRealmstone) {
                if (world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() instanceof PortalBlock) {
                    world.func_175656_a(pos.func_177972_a(Direction.UP), Blocks.field_150350_a.func_176223_P());
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }
}

