/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.util.BlockUtil;

public class CropBlock
extends CropsBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))};
    private final Supplier<Item> seedItem;

    public CropBlock(MaterialColor colour, Supplier<Item> seedItem) {
        super(BlockUtil.generateBlockProperties(Material.field_151585_k, colour, 0.0f, 0.0f, SoundType.field_222472_s).func_200942_a().func_200944_c());
        this.seedItem = seedItem;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            if (!world.field_72995_K) {
                NonNullList drops = NonNullList.func_191196_a();
                int fortune = Math.max(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184586_b(Hand.MAIN_HAND)), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184586_b(Hand.OFF_HAND)));
                drops.addAll((Collection)CropBlock.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184586_b(hand)));
                float dropChance = ForgeEventFactory.fireBlockHarvesting((NonNullList)drops, (World)world, (BlockPos)pos, (BlockState)state, (int)fortune, (float)1.0f, (boolean)false, (PlayerEntity)player);
                for (ItemStack stack : drops) {
                    if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
                    CropBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
                world.func_180501_a(pos, this.func_176223_P(), 2);
                ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos), (Direction)hit.func_216354_b());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected IItemProvider func_199772_f() {
        return (IItemProvider)this.seedItem.get();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)field_176488_a)];
    }
}

