/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.boss.VinocorneEntity;
import net.tslat.aoa3.util.BlockUtil;

public class LivingGrowth
extends Block {
    public static final IntegerProperty GROWTH_STAGE = BlockStateProperties.field_208169_V;
    private static final VoxelShape[] AGE_SHAPES = new VoxelShape[]{VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.4375, 0.9375)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.001, 0.0, 0.001, 0.99, 1.625, 0.99)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.001, 0.0, 0.001, 0.99, 1.625, 0.99))};

    public LivingGrowth() {
        super(BlockUtil.generateBlockProperties(Material.field_151585_k, MaterialColor.field_151651_C, 1.0f, 0.0f, SoundType.field_185850_c));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AGE_SHAPES[(Integer)state.func_177229_b((IProperty)GROWTH_STAGE)];
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        int currentAge = (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
        if (currentAge < 6) {
            if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                ItemEntity itemEntity = new ItemEntity(EntityType.field_200765_E, (World)world);
                itemEntity.func_92058_a(new ItemStack((IItemProvider)AoAItems.PETALS.get()));
                itemEntity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
                world.func_217376_c((Entity)itemEntity);
            } else if (currentAge == 5) {
                VinocorneEntity vinocorne = new VinocorneEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.VINOCORNE.get()), (World)world);
                vinocorne.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                world.func_217376_c((Entity)vinocorne);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            } else {
                world.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(currentAge + 1)));
                world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 40);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{GROWTH_STAGE});
    }
}

