/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.block.WaterloggableBlock;
import net.tslat.aoa3.block.tileentity.TrophyTileEntity;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.apache.logging.log4j.Level;

public class TrophyBlock
extends WaterloggableBlock {
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)4.5, (double)9.0, (double)4.5, (double)11.5, (double)11.0, (double)11.5);
    private static final VoxelShape FULL_AABB = VoxelShapes.func_216384_a((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{MIDDLE_SHAPE, TOP_SHAPE});

    public TrophyBlock() {
        super(BlockUtil.generateBlockProperties(new Material(MaterialColor.field_151647_F, false, true, true, true, true, false, false, PushReaction.BLOCK), MaterialColor.field_151665_m, 10.0f, 2000.0f));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return FULL_AABB;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TrophyTileEntity();
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.PICKAXE;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        CompoundNBT dataTag;
        CompoundNBT tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("BlockEntityTag") && (dataTag = tag.func_74775_l("BlockEntityTag")).func_150297_b("EntityID", 8) && (tile = worldIn.func_175625_s(pos)) instanceof TrophyTileEntity) {
            ((TrophyTileEntity)tile).setEntity(dataTag.func_74779_i("EntityID"), dataTag.func_74764_b("OriginalTrophy") && !dataTag.func_74767_n("OriginalTrophy"));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof SpawnEggItem) {
            TileEntity tile = world.func_175625_s(pos);
            SpawnEggItem egg = (SpawnEggItem)heldStack.func_77973_b();
            if (tile instanceof TrophyTileEntity) {
                ((TrophyTileEntity)tile).setEntity(egg.func_208076_b(heldStack.func_77978_p()).getRegistryName().toString(), true);
                if (!world.func_201670_d() && !player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TrophyTileEntity trophyTile;
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TrophyTileEntity && (trophyTile = (TrophyTileEntity)tile).getEntityId() != null) {
            CompoundNBT nbt = new CompoundNBT();
            CompoundNBT dataTag = new CompoundNBT();
            dataTag.func_74778_a("EntityID", ((TrophyTileEntity)tile).getEntityId());
            dataTag.func_74757_a("OriginalTrophy", ((TrophyTileEntity)tile).isOriginal());
            nbt.func_218657_a("BlockEntityTag", (INBT)dataTag);
            stack.func_77982_d(nbt);
            if (trophyTile.getCachedEntity() != null) {
                Entity cachedEntity = ((TrophyTileEntity)tile).getCachedEntity();
                String entityName = cachedEntity == null ? "" : LocaleUtil.getLocaleString(cachedEntity.func_200600_R().func_210760_d());
                stack.func_200302_a((ITextComponent)LocaleUtil.getLocaleMessage("block.aoa3.trophy.desc", entityName));
            }
        }
        return stack;
    }

    public static CompoundNBT getTagForEntity(EntityType<?> entity) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT dataTag = new CompoundNBT();
        dataTag.func_74778_a("EntityID", entity.getRegistryName().toString());
        dataTag.func_74757_a("OriginalTrophy", true);
        nbt.func_218657_a("BlockEntityTag", (INBT)dataTag);
        return nbt;
    }

    public static ItemStack cloneTrophy(ItemStack sourceTrophy, IItemProvider destTrophy) {
        CompoundNBT sourceTag = sourceTrophy.func_196082_o();
        ItemStack newStack = new ItemStack((IItemProvider)destTrophy.func_199767_j());
        CompoundNBT destTag = newStack.func_196082_o();
        try {
            if (sourceTag.isEmpty()) {
                return newStack;
            }
            if (sourceTag.func_74764_b("BlockEntityTag")) {
                destTag.func_218657_a("BlockEntityTag", (INBT)sourceTag.func_74775_l("BlockEntityTag"));
            }
            if (sourceTag.func_74764_b("display")) {
                CompoundNBT displayTag = new CompoundNBT();
                String localePrefix = "block.aoa3.trophy.desc";
                if (destTrophy == AoABlocks.GOLD_TROPHY.get()) {
                    localePrefix = "block.aoa3.gold_trophy.desc";
                } else if (destTrophy == AoABlocks.ORNATE_TROPHY.get()) {
                    localePrefix = "block.aoa3.ornate_trophy.desc";
                }
                if (sourceTag.func_74764_b("BlockEntityTag")) {
                    displayTag.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent(localePrefix, new Object[]{new TranslationTextComponent(Util.func_200697_a((String)"entity", (ResourceLocation)new ResourceLocation(sourceTag.func_74775_l("BlockEntityTag").func_74779_i("EntityID"))), new Object[0])})));
                } else {
                    displayTag = sourceTag.func_74775_l("display");
                }
                destTag.func_218657_a("display", (INBT)displayTag);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(Level.ERROR, "Failed to clone trophy data.", ex);
        }
        return newStack;
    }

    public static CompoundNBT getOriginalTrophyTag(EntityType<?> entity, Block trophyBlock) {
        CompoundNBT tag = TrophyBlock.getTagForEntity(entity);
        CompoundNBT displayTag = new CompoundNBT();
        String localePrefix = "block.aoa3.trophy.desc";
        if (trophyBlock == AoABlocks.GOLD_TROPHY.get()) {
            localePrefix = "block.aoa3.gold_trophy.desc";
        } else if (trophyBlock == AoABlocks.ORNATE_TROPHY.get()) {
            localePrefix = "block.aoa3.ornate_trophy.desc";
        }
        displayTag.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent(localePrefix, new Object[]{new TranslationTextComponent(entity.func_210760_d(), new Object[0])})));
        tag.func_218657_a("display", (INBT)displayTag);
        return tag;
    }
}

