/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.portal;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.library.misc.CustomisableParticleType;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.worldgen.worlds.abyss.AbyssTeleporter;
import net.tslat.aoa3.worldgen.worlds.ancientcavern.AncientCavernTeleporter;
import net.tslat.aoa3.worldgen.worlds.barathos.BarathosTeleporter;
import net.tslat.aoa3.worldgen.worlds.candyland.CandylandTeleporter;
import net.tslat.aoa3.worldgen.worlds.celeve.CeleveTeleporter;
import net.tslat.aoa3.worldgen.worlds.creeponia.CreeponiaTeleporter;
import net.tslat.aoa3.worldgen.worlds.crystevia.CrysteviaTeleporter;
import net.tslat.aoa3.worldgen.worlds.deeplands.DeeplandsTeleporter;
import net.tslat.aoa3.worldgen.worlds.dustopia.DustopiaTeleporter;
import net.tslat.aoa3.worldgen.worlds.gardencia.GardenciaTeleporter;
import net.tslat.aoa3.worldgen.worlds.greckon.GreckonTeleporter;
import net.tslat.aoa3.worldgen.worlds.haven.HavenTeleporter;
import net.tslat.aoa3.worldgen.worlds.immortallis.ImmortallisTeleporter;
import net.tslat.aoa3.worldgen.worlds.iromine.IromineTeleporter;
import net.tslat.aoa3.worldgen.worlds.lborean.LBoreanTeleporter;
import net.tslat.aoa3.worldgen.worlds.lelyetia.LelyetiaTeleporter;
import net.tslat.aoa3.worldgen.worlds.lunalus.LunalusTeleporter;
import net.tslat.aoa3.worldgen.worlds.mysterium.MysteriumTeleporter;
import net.tslat.aoa3.worldgen.worlds.nether.NetherTeleporter;
import net.tslat.aoa3.worldgen.worlds.precasia.PrecasiaTeleporter;
import net.tslat.aoa3.worldgen.worlds.runandor.RunandorTeleporter;
import net.tslat.aoa3.worldgen.worlds.shyrelands.ShyrelandsTeleporter;
import net.tslat.aoa3.worldgen.worlds.voxponds.VoxPondsTeleporter;

public class PortalBlock
extends Block {
    private static final VoxelShape X_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0));
    private static final VoxelShape Z_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625));
    private final int particleColour;
    private final Supplier<DimensionType> dimension;

    public PortalBlock(Supplier<DimensionType> dimType, MaterialColor mapColour, int particleColour) {
        super(BlockUtil.generateBlockProperties(Material.field_151567_E, mapColour, -1.0f, 1.0E9f, 11).func_200947_a(SoundType.field_185853_f).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.X));
        this.particleColour = particleColour;
        this.dimension = dimType;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z)) {
            case Z: {
                return Z_SHAPE;
            }
        }
        return X_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)EntityUtil.getDirectionFacing((Entity)context.func_195999_j(), true).func_176740_k());
    }

    private boolean isCompatibleNeighbour(World world, BlockPos pos) {
        BlockState block = world.func_180495_p(pos);
        return block.func_177230_c() == this || !block.isAir((IBlockReader)world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacent, Direction side) {
        if (adjacent.func_177230_c() == this) {
            switch ((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z)) {
                case X: {
                    Direction.Axis axis = (Direction.Axis)adjacent.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
                    if (axis != Direction.Axis.X) break;
                    return true;
                }
                case Z: {
                    Direction.Axis axis = (Direction.Axis)adjacent.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
                    if (axis != Direction.Axis.Z) break;
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double posXStart = (float)pos.func_177958_n() + rand.nextFloat();
            double posYStart = (float)pos.func_177956_o() + rand.nextFloat();
            double posZStart = (float)pos.func_177952_p() + rand.nextFloat();
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int randomMod = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                posXStart = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.nextFloat() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.nextFloat() * 2.0f * (float)randomMod;
            }
            world.func_195594_a((IParticleData)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.PORTAL_FLOATER.get()), this.particleColour), posXStart, posYStart, posZStart, motionX, motionY, motionZ);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.func_201670_d() && entity.func_184187_bx() == null && !entity.func_184207_aI()) {
            if ((Boolean)AoAConfig.SERVER.allowNonPlayerPortalTravel.get() == false & !(entity instanceof PlayerEntity)) {
                return;
            }
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = 30;
                return;
            }
            if (this.dimension.get() == null) {
                return;
            }
            NetherTeleporter teleporter = this.dimension.get() == DimensionType.field_223228_b_ ? new NetherTeleporter() : PortalBlock.getTeleporterForWorld(world.func_73046_m().func_71218_a(this.dimension.get()));
            PortalCoordinatesContainer portalLoc = null;
            if (entity instanceof PlayerEntity) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)entity);
                portalLoc = plData.getPortalReturnLocation(world.func_201675_m().func_186058_p());
                ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            entity = portalLoc == null ? (world.func_201675_m().func_186058_p() == this.dimension.get() ? entity.changeDimension(DimensionType.field_223227_a_, (ITeleporter)teleporter) : entity.changeDimension(this.dimension.get(), (ITeleporter)teleporter)) : (world.func_201675_m().func_186058_p() != this.dimension.get() ? entity.changeDimension(this.dimension.get(), (ITeleporter)teleporter) : entity.changeDimension(portalLoc.fromDim, (ITeleporter)teleporter));
            if (entity != null) {
                entity.field_71088_bW = 100;
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z)) {
                    case Z: {
                        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208199_z});
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177977_b())) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return;
        }
        switch ((Direction.Axis)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperties.field_208199_z)) {
            case Z: {
                if (!world.func_175623_d(pos.func_177974_f()) && !world.func_175623_d(pos.func_177976_e())) break;
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                break;
            }
            case X: {
                if (!world.func_175623_d(pos.func_177978_c()) && !world.func_175623_d(pos.func_177968_d())) break;
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction.Axis facing = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
        switch (facing) {
            case Z: {
                if (this.isCompatibleNeighbour(world, pos.func_177984_a()) && this.isCompatibleNeighbour(world, pos.func_177977_b()) && this.isCompatibleNeighbour(world, pos.func_177974_f()) && this.isCompatibleNeighbour(world, pos.func_177976_e())) break;
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                break;
            }
            case X: {
                if (this.isCompatibleNeighbour(world, pos.func_177984_a()) && this.isCompatibleNeighbour(world, pos.func_177977_b()) && this.isCompatibleNeighbour(world, pos.func_177978_c()) && this.isCompatibleNeighbour(world, pos.func_177968_d())) break;
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public static ITeleporter getTeleporterForWorld(ServerWorld world) {
        DimensionType dimType = world.field_73011_w.func_186058_p();
        AoADimensions.AoADimension aoaDim = AoADimensions.AoADimension.fromDimType(dimType);
        if (dimType.isVanilla() || aoaDim == AoADimensions.AoADimension.NONE || aoaDim == null) {
            return world.func_85176_s();
        }
        switch (aoaDim) {
            case ABYSS: {
                return new AbyssTeleporter();
            }
            case ANCIENT_CAVERN: {
                return new AncientCavernTeleporter();
            }
            case BARATHOS: {
                return new BarathosTeleporter();
            }
            case CANDYLAND: {
                return new CandylandTeleporter();
            }
            case CELEVE: {
                return new CeleveTeleporter();
            }
            case CREEPONIA: {
                return new CreeponiaTeleporter();
            }
            case CRYSTEVIA: {
                return new CrysteviaTeleporter();
            }
            case DEEPLANDS: {
                return new DeeplandsTeleporter();
            }
            case DUSTOPIA: {
                return new DustopiaTeleporter();
            }
            case GARDENCIA: {
                return new GardenciaTeleporter();
            }
            case GRECKON: {
                return new GreckonTeleporter();
            }
            case HAVEN: {
                return new HavenTeleporter();
            }
            case IMMORTALLIS: {
                return new ImmortallisTeleporter();
            }
            case IROMINE: {
                return new IromineTeleporter();
            }
            case LBOREAN: {
                return new LBoreanTeleporter();
            }
            case LELYETIA: {
                return new LelyetiaTeleporter();
            }
            case LUNALUS: {
                return new LunalusTeleporter();
            }
            case MYSTERIUM: {
                return new MysteriumTeleporter();
            }
            case PRECASIA: {
                return new PrecasiaTeleporter();
            }
            case RUNANDOR: {
                return new RunandorTeleporter();
            }
            case SHYRELANDS: {
                return new ShyrelandsTeleporter();
            }
            case VOX_PONDS: {
                return new VoxPondsTeleporter();
            }
        }
        return world.func_85176_s();
    }
}

