/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.boss.ConiferonEntity;
import net.tslat.aoa3.entity.boss.GoldorthEntity;
import net.tslat.aoa3.entity.boss.HoronEntity;
import net.tslat.aoa3.entity.boss.PenumbraEntity;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class AncientCavernShrine
extends Block {
    private final Deities deity;

    public AncientCavernShrine(Deities deity) {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151670_w, -1.0f, 1.0E9f, SoundType.field_185851_d));
        this.deity = deity;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity && !player.func_225608_bj_() && world.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type()) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            BlockPos teleportPos = new BlockPos(0, 17, 0);
            switch (this.deity) {
                case EREBON: {
                    if (pos.func_177958_n() <= -20 && pos.func_177952_p() >= 60) break;
                    teleportPos = new BlockPos(-70, 18, 80);
                    if (!player.func_184812_l_()) {
                        if (plData.stats().getLevel(Skills.HUNTER) < 70) {
                            PlayerUtil.notifyPlayerOfInsufficientLevel((ServerPlayerEntity)player, Skills.HUNTER, 70);
                            return ActionResultType.PASS;
                        }
                        if (plData.stats().getTribute(Deities.EREBON) < 200) {
                            PlayerUtil.notifyPlayerOfInsufficientTribute((ServerPlayerEntity)player, Deities.EREBON, 200);
                            return ActionResultType.PASS;
                        }
                        plData.stats().addTribute(Deities.EREBON, -20);
                    }
                    PenumbraEntity penumbra = new PenumbraEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.PENUMBRA.get()), world);
                    penumbra.func_70012_b(-51.0, 18.0, 92.0, 0.0f, 0.0f);
                    world.func_217376_c((Entity)penumbra);
                    break;
                }
                case LUXON: {
                    if (pos.func_177958_n() >= 60 && pos.func_177952_p() <= -20) break;
                    teleportPos = new BlockPos(80, 18, -70);
                    if (!player.func_184812_l_()) {
                        if (plData.stats().getLevel(Skills.RUNATION) < 70) {
                            PlayerUtil.notifyPlayerOfInsufficientLevel((ServerPlayerEntity)player, Skills.RUNATION, 70);
                            return ActionResultType.PASS;
                        }
                        if (plData.stats().getTribute(Deities.LUXON) < 200) {
                            PlayerUtil.notifyPlayerOfInsufficientTribute((ServerPlayerEntity)player, Deities.LUXON, 200);
                            return ActionResultType.PASS;
                        }
                        plData.stats().addTribute(Deities.LUXON, -20);
                    }
                    HoronEntity horon = new HoronEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.HORON.get()), world);
                    horon.func_70012_b(80.0, 18.0, -70.0, 0.0f, 0.0f);
                    world.func_217376_c((Entity)horon);
                    break;
                }
                case PLUTON: {
                    if (pos.func_177958_n() >= 60 && pos.func_177952_p() >= 60) break;
                    teleportPos = new BlockPos(80, 18, 80);
                    if (!player.func_184812_l_()) {
                        if (plData.stats().getLevel(Skills.FORAGING) < 70) {
                            PlayerUtil.notifyPlayerOfInsufficientLevel((ServerPlayerEntity)player, Skills.FORAGING, 70);
                            return ActionResultType.PASS;
                        }
                        if (plData.stats().getTribute(Deities.PLUTON) < 200) {
                            PlayerUtil.notifyPlayerOfInsufficientTribute((ServerPlayerEntity)player, Deities.PLUTON, 200);
                            return ActionResultType.PASS;
                        }
                        plData.stats().addTribute(Deities.PLUTON, -20);
                    }
                    GoldorthEntity goldorth = new GoldorthEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.GOLDORTH.get()), world);
                    goldorth.func_70012_b(80.0, 18.0, 80.0, 0.0f, 0.0f);
                    world.func_217376_c((Entity)goldorth);
                    break;
                }
                case SELYAN: {
                    if (pos.func_177958_n() <= -20 && pos.func_177952_p() <= -20) break;
                    teleportPos = new BlockPos(-60, 18, -65);
                    if (!player.func_184812_l_()) {
                        if (plData.stats().getLevel(Skills.INFUSION) < 70) {
                            PlayerUtil.notifyPlayerOfInsufficientLevel((ServerPlayerEntity)player, Skills.INFUSION, 70);
                            return ActionResultType.PASS;
                        }
                        if (plData.stats().getTribute(Deities.SELYAN) < 200) {
                            PlayerUtil.notifyPlayerOfInsufficientTribute((ServerPlayerEntity)player, Deities.SELYAN, 200);
                            return ActionResultType.PASS;
                        }
                        plData.stats().addTribute(Deities.SELYAN, -20);
                    }
                    ConiferonEntity coniferon = new ConiferonEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CONIFERON.get()), world);
                    coniferon.func_70012_b(-60.0, 18.0, -65.0, 0.0f, 0.0f);
                    world.func_217376_c((Entity)coniferon);
                }
            }
            player.func_70634_a((double)teleportPos.func_177958_n(), (double)teleportPos.func_177956_o(), (double)teleportPos.func_177952_p());
        }
        return ActionResultType.SUCCESS;
    }
}

