/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.tool.misc.InfusionBowl;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.ExtractionUtil;

public class ExtractionDevice
extends Block {
    public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");

    public ExtractionDevice() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151654_J, 5.0f, 10.0f, SoundType.field_185851_d).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            BlockState topBlock = world.func_180495_p(pos.func_177984_a());
            if (!((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue() && topBlock.func_204520_s().func_206889_d() && topBlock.func_204520_s().func_206884_a(FluidTags.field_206960_b)) {
                world.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)));
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        if (world instanceof ServerWorld) {
            this.func_225534_a_(state, (ServerWorld)world, pos, world.field_73012_v);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if ((Boolean)state.func_177229_b((IProperty)FILLED) == false) return ActionResultType.FAIL;
        if (!(player.func_184586_b(hand).func_77973_b() instanceof InfusionBowl)) return ActionResultType.FAIL;
        if (!(player instanceof ServerPlayerEntity)) return ActionResultType.PASS;
        PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
        ItemStack heldStack = player.func_184586_b(hand);
        if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j()) {
            if (!World.func_189509_E((BlockPos)pos.func_177977_b())) {
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.extraction.noSpace", TextFormatting.RED));
                return ActionResultType.PASS;
            }
        }
        int lvl = plData.stats().getLevel(Skills.EXTRACTION);
        world.func_175656_a(pos, this.func_176223_P());
        if (plData.equipment().getCurrentFullArmourSet() != AdventArmour.Type.EXTRACTION) {
            world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
        }
        if (!ExtractionUtil.shouldGetLoot(lvl)) {
            player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.extraction.fail"));
            return ActionResultType.PASS;
        }
        if (!player.func_184812_l_()) {
            ItemUtil.damageItem(heldStack, (LivingEntity)player, hand);
        }
        List<ItemStack> loot = ExtractionUtil.getLoot((ServerPlayerEntity)player, pos);
        Iterator<ItemStack> iterator = loot.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldStack.func_77973_b()));
                plData.stats().addXp(Skills.EXTRACTION, PlayerUtil.getXpRequiredForNextLevel(lvl) / (float)ExtractionUtil.getXpDenominator(lvl), false, false);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)AoASounds.BLOCK_EXTRACTION_DEVICE_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) return ActionResultType.PASS;
                if (!player.field_70170_p.func_72935_r()) return ActionResultType.PASS;
                plData.stats().addTribute(Deities.PLUTON, 4);
                return ActionResultType.PASS;
            }
            ItemStack stack = iterator.next();
            if (!stack.func_190926_b()) {
                player.func_145747_a(LocaleUtil.getLocaleMessage("message.feedback.extraction").func_150257_a((ITextComponent)new TranslationTextComponent(stack.func_77977_a(), new Object[0])));
            } else {
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.extraction.nothing"));
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FILLED});
    }
}

