/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.boss.FlashEntity;
import net.tslat.aoa3.entity.boss.KlobberEntity;
import net.tslat.aoa3.entity.boss.MirageEntity;
import net.tslat.aoa3.entity.boss.ProshieldEntity;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ImmortallisProgressor
extends Block {
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)1, (int)9);

    public ImmortallisProgressor() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151647_F, -1.0f, 1.0E9f, SoundType.field_185851_d));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!(player instanceof ServerPlayerEntity)) {
            return ActionResultType.SUCCESS;
        }
        PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
        switch ((Integer)state.func_177229_b((IProperty)STAGE)) {
            case 1: {
                if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), true, 1)) break;
                ItemUtil.clearInventoryOfItems(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), new ItemStack((IItemProvider)AoAItems.RETURN_CRYSTAL.get()));
                if (!player.func_191521_c(new ItemStack((IItemProvider)AoAItems.RETURN_CRYSTAL.get()))) {
                    plData.sendThrottledChatMessage("message.feedback.item.returnCrystal.noSpace", new Object[0]);
                    plData.stats().resetAllTribute();
                    player.func_70099_a(new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), 0.5f);
                } else {
                    player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.goldStart.0", TextFormatting.GOLD));
                    player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.goldStart.1", TextFormatting.GOLD));
                    player.func_70634_a(28.0, 20.0, 2.0);
                }
                return ActionResultType.SUCCESS;
            }
            case 2: {
                if (plData.stats().getTribute(Deities.PLUTON) < 100) break;
                KlobberEntity klobber = new KlobberEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.KLOBBER.get()), world);
                klobber.func_70634_a(69.0, 21.0, 4.0);
                world.func_217376_c((Entity)klobber);
                player.func_70634_a(67.0, 21.0, 2.0);
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.klobberStart", TextFormatting.DARK_AQUA));
                return ActionResultType.SUCCESS;
            }
            case 3: {
                if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), true, 1)) break;
                ItemUtil.clearInventoryOfItems(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()));
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.skeletalSpiritsStart", TextFormatting.RED));
                player.func_70634_a(81.0, 21.0, 2.0);
                return ActionResultType.SUCCESS;
            }
            case 4: {
                if (plData.stats().getTribute(Deities.EREBON) < 100) break;
                ProshieldEntity proshield = new ProshieldEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.PROSHIELD.get()), world);
                proshield.func_70634_a(123.0, 21.0, 6.0);
                world.func_217376_c((Entity)proshield);
                player.func_70634_a(122.0, 21.0, 2.0);
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.proshieldStart", TextFormatting.DARK_AQUA));
                return ActionResultType.SUCCESS;
            }
            case 5: {
                if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), true, 1)) break;
                ItemUtil.clearInventoryOfItems(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()));
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.pureGoldStart.0", TextFormatting.GOLD));
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.pureGoldStart.1", TextFormatting.GOLD));
                player.func_70634_a(141.0, 24.0, 2.0);
                return ActionResultType.SUCCESS;
            }
            case 6: {
                if (plData.stats().getTribute(Deities.PLUTON) != 200) break;
                MirageEntity mirage = new MirageEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.MIRAGE.get()), world);
                mirage.func_70634_a(177.0, 24.0, -2.0);
                world.func_217376_c((Entity)mirage);
                player.func_70634_a(168.0, 24.0, 7.0);
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.mirageStart", TextFormatting.DARK_AQUA));
                return ActionResultType.SUCCESS;
            }
            case 7: {
                if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), true, 1)) break;
                ItemUtil.clearInventoryOfItems(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()));
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.evilSpiritsStart", TextFormatting.RED));
                player.func_70634_a(189.0, 20.0, 2.0);
                return ActionResultType.SUCCESS;
            }
            case 8: {
                if (plData.stats().getTribute(Deities.EREBON) != 200) break;
                FlashEntity flash = new FlashEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.FLASH.get()), world);
                flash.func_70634_a(235.0, 22.0, 10.0);
                world.func_217376_c((Entity)flash);
                player.func_70634_a(233.0, 21.0, 3.0);
                player.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.feedback.immortallisProgression.flashStart", TextFormatting.DARK_AQUA));
                return ActionResultType.SUCCESS;
            }
            case 9: {
                if (!ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), true, 1)) break;
                ItemUtil.clearInventoryOfItems(player, new ItemStack((IItemProvider)AoAItems.PROGRESS_TOKEN.get()), new ItemStack((IItemProvider)AoAItems.RETURN_CRYSTAL.get()));
                player.func_70634_a(0.0, 20.0, 0.0);
                plData.stats().resetAllTribute();
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }
}

