/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.common.container.InfusionTableContainer;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.misc.InfusionStone;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class InfusionTable
extends Block {
    public InfusionTable() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151678_z, 10.0f, 15.0f, SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            ItemStack stack = player.func_184586_b(hand);
            Item item = stack.func_77973_b();
            if (item instanceof InfusionStone) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
                InfusionStone stone = (InfusionStone)item;
                int count = stack.func_190916_E();
                if (player.func_184812_l_() || plData.stats().getLevel(Skills.INFUSION) >= stone.getLvl()) {
                    plData.stats().addXp(Skills.INFUSION, stone.getXp() * (float)count, false, false);
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)AoASounds.BLOCK_INFUSION_TABLE_CONVERT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    int chanceMod = plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.INFUSION ? 33 : 100;
                    int powerStoneCount = 0;
                    for (int i = 0; i < count; ++i) {
                        if (!RandomUtil.oneInNChance(chanceMod)) continue;
                        ++powerStoneCount;
                    }
                    if (!player.func_184812_l_()) {
                        if (powerStoneCount > 0) {
                            player.func_184611_a(hand, new ItemStack((IItemProvider)stone.getPowerStone(), powerStoneCount));
                        } else {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    } else {
                        ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)stone.getPowerStone(), powerStoneCount));
                    }
                }
            } else {
                InfusionTableContainer.openContainer((ServerPlayerEntity)player, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }
}

