/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAArmour;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.WorldUtil;

public class LunarCreationTable
extends Block {
    public LunarCreationTable() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151678_z, -1.0f, 1.0E9f, SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            BlockPos lunarPos = null;
            BlockPos moonlightPos = null;
            BlockPos darklightPos = null;
            BlockPos sunfirePos = null;
            BlockPos duskPos = null;
            for (int x = -2; x <= 2; x += 2) {
                for (int z = -2; z <= 2; z += 2) {
                    BlockPos checkPos = pos.func_177982_a(x, 0, z);
                    BlockState block = world.func_180495_p(checkPos);
                    if (block.func_177230_c() == AoABlocks.LUNAR_ORB.get()) {
                        lunarPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == AoABlocks.MOONLIGHT_ORB.get()) {
                        moonlightPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == AoABlocks.DARKLIGHT_ORB.get()) {
                        darklightPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == AoABlocks.DUSK_ORB.get()) {
                        duskPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() != AoABlocks.SUNFIRE_ORB.get()) continue;
                    sunfirePos = checkPos;
                }
            }
            if (lunarPos != null && moonlightPos != null) {
                if (darklightPos != null && sunfirePos != null && duskPos != null) {
                    HashSet<Object> armours = new HashSet<Object>(4);
                    armours.add(AoAArmour.LUNAR_ARMOUR.boots.get());
                    armours.add(AoAArmour.LUNAR_ARMOUR.leggings.get());
                    armours.add(AoAArmour.LUNAR_ARMOUR.chestplate.get());
                    armours.add(AoAArmour.LUNAR_ARMOUR.helmet.get());
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    if (armours.isEmpty()) {
                        armours.add(AoAArmour.LUNAR_ARMOUR.boots.get());
                        armours.add(AoAArmour.LUNAR_ARMOUR.leggings.get());
                        armours.add(AoAArmour.LUNAR_ARMOUR.chestplate.get());
                        armours.add(AoAArmour.LUNAR_ARMOUR.helmet.get());
                    }
                    Item armourPiece = (Item)armours.toArray()[player.func_70681_au().nextInt(armours.size())];
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)armourPiece)));
                    WorldUtil.toAir(world, lunarPos, moonlightPos, duskPos, sunfirePos, darklightPos);
                } else {
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)AoAItems.OBSERVING_EYE.get())));
                    WorldUtil.toAir(world, lunarPos, moonlightPos);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }
}

