/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class RuneRandomizer
extends Block {
    public RuneRandomizer() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151679_y, -1.0f, 1.0E9f, SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == AoAItems.UNPOWERED_RUNE.get() || heldItem.func_77973_b() == AoAItems.CHARGED_RUNE.get()) {
            if (player instanceof ServerPlayerEntity) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
                if (!player.func_184812_l_() && plData.stats().getLevel(Skills.RUNATION) < 20) {
                    PlayerUtil.notifyPlayerOfInsufficientLevel(plData.player(), Skills.RUNATION, 20);
                    return ActionResultType.FAIL;
                }
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                ItemUtil.givePlayerMultipleItems(player, LootUtil.generateLoot((ServerWorld)world, new ResourceLocation("aoa3", "misc/rune_randomizer"), LootUtil.getGiftContext((ServerWorld)world, pos, (Entity)player)));
                if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.RUNATION) {
                    ItemUtil.givePlayerMultipleItems(player, LootUtil.generateLoot((ServerWorld)world, new ResourceLocation("aoa3", "misc/rune_randomizer"), LootUtil.getGiftContext((ServerWorld)world, pos, (Entity)player)));
                }
                plData.stats().addXp(Skills.RUNATION, 5.0f, false, false);
                player.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)AoASounds.BLOCK_RUNE_RANDOMIZER_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

