/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.block.generation.misc.RunePostBlock;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class RuneShrine
extends Block {
    public RuneShrine() {
        super(BlockUtil.generateBlockProperties(Material.field_151576_e, MaterialColor.field_151670_w, 5.0f, 10.0f, SoundType.field_185851_d));
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() != AoAItems.UNPOWERED_RUNE.get()) {
            if (heldStack.func_77973_b() != AoAItems.CHARGED_RUNE.get()) return ActionResultType.PASS;
        }
        if (!(player instanceof ServerPlayerEntity)) return ActionResultType.SUCCESS;
        BlockPos basePos = pos.func_177981_b(2);
        Block post1 = world.func_180495_p(basePos.func_177964_d(3).func_177965_g(3)).func_177230_c();
        PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
        if (post1 instanceof RunePostBlock) {
            if (((RunePostBlock)post1).getLevelReq() > plData.stats().getLevel(Skills.RUNATION)) {
                PlayerUtil.notifyPlayerOfInsufficientLevel(plData.player(), Skills.RUNATION, ((RunePostBlock)post1).getLevelReq());
                return ActionResultType.FAIL;
            }
            RuneItem rune = ((RunePostBlock)post1).getRune();
            if (rune.isCharged() && heldStack.func_77973_b() != AoAItems.CHARGED_RUNE.get()) {
                return ActionResultType.FAIL;
            }
            Block post2 = world.func_180495_p(basePos.func_177964_d(3).func_177985_f(3)).func_177230_c();
            Block post3 = world.func_180495_p(basePos.func_177970_e(3).func_177965_g(3)).func_177230_c();
            Block post4 = world.func_180495_p(basePos.func_177970_e(3).func_177985_f(3)).func_177230_c();
            if (post1 != post2) return ActionResultType.FAIL;
            if (post2 != post3) return ActionResultType.FAIL;
            if (post3 != post4) return ActionResultType.FAIL;
            int runeCount = heldStack.func_190916_E();
            if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.RUNATION) {
                runeCount *= 2;
            }
            plData.stats().addXp(Skills.RUNATION, ((RunePostBlock)post1).getXpGain() * (float)heldStack.func_190916_E(), false, false);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)AoASounds.BLOCK_RUNE_SHRINE_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                int handCount = Math.min(64, runeCount);
                player.func_184611_a(hand, new ItemStack((IItemProvider)rune, handCount));
                if ((runeCount -= handCount) > 0) {
                    ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)rune, runeCount));
                }
            } else {
                while (runeCount > 64) {
                    ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)rune, 64));
                    runeCount -= 64;
                }
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)rune, runeCount));
            }
            player.field_71069_bz.func_75142_b();
            return ActionResultType.SUCCESS;
        }
        if (!player.func_184812_l_()) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        plData.sendThrottledChatMessage("message.feedback.runeShrine.practice", new Object[0]);
        plData.stats().addXp(Skills.RUNATION, 2 * heldStack.func_190916_E(), false, false);
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)AoASounds.BLOCK_RUNE_SHRINE_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        player.field_71069_bz.func_75142_b();
        return ActionResultType.SUCCESS;
    }
}

