/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.grass;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class GrassBlock
extends net.minecraft.block.GrassBlock {
    protected final Supplier<Block> soilBlock;
    protected final boolean growsInDark;

    public GrassBlock(MaterialColor mapColour, Supplier<Block> soilBlock, boolean growsInDark) {
        super(GrassBlock.generateBlockProperties(mapColour));
        this.soilBlock = soilBlock;
        this.growsInDark = growsInDark;
    }

    private static Block.Properties generateBlockProperties(MaterialColor mapColour) {
        Block.Properties blockProperties = Block.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)mapColour);
        blockProperties.func_200943_b(0.6f);
        blockProperties.func_200947_a(SoundType.field_185850_c);
        blockProperties.func_200944_c();
        blockProperties.harvestTool(ToolType.SHOVEL);
        blockProperties.harvestLevel(0);
        return blockProperties;
    }

    public Supplier<Block> getSoilBlock() {
        return this.soilBlock;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
    }

    public boolean hasSufficientLight(BlockState grassState, IWorldReader world, BlockPos grassPos) {
        BlockPos topPos = grassPos.func_177984_a();
        BlockState topBlock = world.func_180495_p(topPos);
        if (topBlock.func_177230_c() == Blocks.field_150433_aE && (Integer)topBlock.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        return LightEngine.func_215613_a((IBlockReader)world, (BlockState)grassState, (BlockPos)grassPos, (BlockState)topBlock, (BlockPos)topPos, (Direction)Direction.UP, (int)topBlock.func_200016_a((IBlockReader)world, topPos)) < world.func_201572_C();
    }

    public boolean canStayGrass(BlockState grassState, IWorldReader world, BlockPos grassPos) {
        return this.hasSufficientLight(grassState, world, grassPos) && !world.func_204610_c(grassPos.func_177984_a()).func_206884_a(FluidTags.field_206959_a);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.hasSufficientLight(state, (IWorldReader)world, pos)) {
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            world.func_175656_a(pos, this.soilBlock.get().func_176223_P());
        } else if (this.growsInDark == world.func_201696_r(pos.func_177984_a()) < 9) {
            BlockState grassState = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos growPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (world.func_180495_p(growPos).func_177230_c() != this.soilBlock.get() || !this.canStayGrass(grassState, (IWorldReader)world, growPos)) continue;
                world.func_175656_a(growPos, (BlockState)grassState.func_206870_a((IProperty)field_196382_a, (Comparable)Boolean.valueOf(world.func_180495_p(growPos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)));
            }
        }
    }
}

