/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.ore;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;
import net.tslat.aoa3.util.RandomUtil;

public class OreBlock
extends Block {
    private final int minXp;
    private final int maxXp;

    public OreBlock(MaterialColor mapColour, int minXp, int maxXp, int harvestLevel) {
        super(OreBlock.generateBlockProperties(mapColour, harvestLevel));
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public OreBlock(MaterialColor mapColour, int harvestLevel) {
        this(mapColour, 0, 0, harvestLevel);
    }

    private static Block.Properties generateBlockProperties(MaterialColor mapColour, int harvestLevel) {
        Block.Properties blockProperties = Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)mapColour);
        blockProperties.func_200948_a(5.0f, 10.0f);
        blockProperties.func_200947_a(SoundType.field_185851_d);
        blockProperties.harvestTool(ToolType.PICKAXE);
        blockProperties.harvestLevel(harvestLevel);
        return blockProperties;
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        if (silktouch > 0 || this.maxXp == 0) {
            return 0;
        }
        return (int)((float)RandomUtil.randomNumberBetween(this.minXp, this.maxXp) * (1.0f + 0.15f * (float)fortune));
    }
}

