/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.tslat.aoa3.util.BlockUtil;

public class GenericPlantBlock
extends Block
implements IShearable,
IPlantable {
    private static final VoxelShape SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9));
    protected final List<Material> growthMaterials;

    public GenericPlantBlock(Material material, MaterialColor mapColour, SoundType sound, Material ... growthMaterials) {
        super(BlockUtil.generateBlockProperties(material, mapColour, 0.0f, 0.0f, sound).func_200942_a());
        this.growthMaterials = Arrays.asList(growthMaterials);
    }

    public GenericPlantBlock(Material material, MaterialColor mapColour, Material ... growthMaterials) {
        this(material, mapColour, SoundType.field_185850_c, growthMaterials);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState targetState = world.func_180495_p(pos.func_177977_b());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.func_185904_a())) && targetState.func_200015_d((IBlockReader)world, pos.func_177977_b());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_196274_w || super.func_196266_a(state, worldIn, pos, type);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        if (world instanceof World) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)this)));
            return drops;
        }
        return new ArrayList<ItemStack>();
    }
}

