/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.tslat.aoa3.util.BlockUtil;

public class StackablePlant
extends Block
implements IShearable,
IPlantable {
    protected Supplier<Block> hatBlock = () -> this;
    protected Supplier<Block> stemBlock = () -> this;
    protected final List<Material> growthMaterials;

    public StackablePlant(Block.Properties properties, Material ... growthMaterial) {
        super(properties);
        this.growthMaterials = Arrays.asList(growthMaterial);
    }

    public StackablePlant(Material material, MaterialColor mapColour, SoundType sound, Material ... growthMaterial) {
        super(BlockUtil.generateBlockProperties(material, mapColour, 0.0f, 0.0f, sound).func_200942_a());
        this.growthMaterials = Arrays.asList(growthMaterial);
    }

    public StackablePlant(MaterialColor mapColour, Material ... growthMaterials) {
        this(Material.field_151582_l, mapColour, SoundType.field_185850_c, growthMaterials);
    }

    public StackablePlant setStemBlock(Supplier<Block> block) {
        this.stemBlock = block;
        return this;
    }

    public StackablePlant setHatBlock(Supplier<Block> block) {
        this.hatBlock = block;
        return this;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos newPos = pos.func_177984_a();
        BlockState blockState = world.func_180495_p(newPos);
        Block block = blockState.func_177230_c();
        while (block == this.stemBlock.get() || block == this.hatBlock.get()) {
            world.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, newPos, Block.func_196246_j((BlockState)blockState));
            if (!world.func_201670_d() && !player.func_184812_l_()) {
                StackablePlant.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
                StackablePlant.func_220054_a((BlockState)blockState, (World)world, (BlockPos)newPos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
            newPos = newPos.func_177984_a();
            blockState = world.func_180495_p(newPos);
            block = blockState.func_177230_c();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState targetState = world.func_180495_p(pos.func_177977_b());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.func_185904_a())) && targetState.func_200015_d((IBlockReader)world, pos.func_177977_b()) || targetState.func_177230_c() == this.stemBlock.get();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_196274_w || super.func_196266_a(state, worldIn, pos, type);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        if (world instanceof World) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)this)));
            return drops;
        }
        return new ArrayList<ItemStack>();
    }
}

