/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.tileentity;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoATileEntities;
import net.tslat.aoa3.util.LocaleUtil;

public class TrophyTileEntity
extends TileEntity
implements ITickableTileEntity,
INameable {
    @Nullable
    private Entity cachedEntity = null;
    @Nullable
    private String entityId = null;
    private boolean isOriginal = true;
    private Block trophyBlock = null;
    private float mobRotation;
    private float prevMobRotation;
    public double hoverStep;

    public TrophyTileEntity() {
        super((TileEntityType)AoATileEntities.TROPHY.get());
    }

    public void setEntity(String entityId, boolean isEgg) {
        this.entityId = entityId;
        this.cachedEntity = null;
        this.isOriginal = !isEgg;
    }

    public void func_73660_a() {
        this.prevMobRotation = this.mobRotation;
        this.mobRotation = (this.mobRotation + 0.05f) % 360.0f;
        if (this.trophyBlock == null && this.field_145850_b != null) {
            this.trophyBlock = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        }
    }

    public float getMobRotation() {
        return this.mobRotation;
    }

    public float getPrevMobRotation() {
        return this.prevMobRotation;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (this.entityId != null) {
            tag.func_74778_a("EntityID", this.entityId);
            tag.func_74757_a("OriginalTrophy", this.isOriginal);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        if (tag.func_150297_b("EntityID", 8)) {
            this.entityId = tag.func_74779_i("EntityID");
            this.isOriginal = tag.func_74767_n("OriginalTrophy");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.entityId != null) {
            compound.func_74778_a("EntityID", this.entityId);
            compound.func_74757_a("OriginalTrophy", this.isOriginal);
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("EntityID")) {
            this.entityId = compound.func_74779_i("EntityID");
            this.isOriginal = compound.func_74767_n("OriginalTrophy");
        }
    }

    @Nullable
    public Entity getCachedEntity() {
        if (this.cachedEntity == null && this.entityId != null) {
            CompoundNBT entityNBT = new CompoundNBT();
            entityNBT.func_74778_a("id", this.entityId);
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)entityNBT, (World)this.func_145831_w(), Function.identity());
            if (this.cachedEntity == null) {
                entityNBT = new CompoundNBT();
                this.entityId = "minecraft:end_crystal";
                entityNBT.func_74778_a("id", this.entityId);
                this.cachedEntity = EntityType.func_220335_a((CompoundNBT)entityNBT, (World)this.func_145831_w(), Function.identity());
            }
            if (entityNBT.func_186856_d() == 1 && entityNBT.func_150297_b("id", 8) && this.cachedEntity instanceof MobEntity) {
                ((MobEntity)this.cachedEntity).func_213386_a((IWorld)this.func_145831_w(), this.func_145831_w().func_175649_E(new BlockPos(this.cachedEntity)), SpawnReason.SPAWNER, null, null);
            }
        }
        return this.cachedEntity;
    }

    public ITextComponent func_200200_C_() {
        if (this.trophyBlock == null || this.entityId == null) {
            return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
        }
        if (this.getCachedEntity() == null) {
            return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
        }
        if (this.trophyBlock == AoABlocks.TROPHY.get()) {
            return new TranslationTextComponent("block.aoa3.trophy.desc", new Object[]{LocaleUtil.getLocaleMessage(this.getCachedEntity().func_200600_R().func_210760_d())});
        }
        if (this.trophyBlock == AoABlocks.GOLD_TROPHY.get()) {
            return new TranslationTextComponent("block.aoa3.gold_trophy.desc", new Object[]{LocaleUtil.getLocaleMessage(this.getCachedEntity().func_200600_R().func_210760_d())});
        }
        if (this.trophyBlock == AoABlocks.ORNATE_TROPHY.get()) {
            return new TranslationTextComponent("block.aoa3.ornate_trophy.desc", new Object[]{LocaleUtil.getLocaleMessage(this.getCachedEntity().func_200600_R().func_210760_d())});
        }
        return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
    }

    public boolean func_145818_k_() {
        return this.trophyBlock != null && this.entityId != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_200200_C_();
    }
}

