/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.capabilities.persistentstack;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapability;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackStorage;

public class PersistentStackCapabilityProvider
implements ICapabilitySerializable<FloatNBT> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "persistent_stack");
    @CapabilityInject(value=PersistentStackCapabilityHandles.class)
    public static final Capability<PersistentStackCapabilityHandles> INSTANCE = null;
    private final LazyOptional<PersistentStackCapability> implContainer = LazyOptional.of(PersistentStackCapability::new);
    private final Direction dir;

    public PersistentStackCapabilityProvider(@Nullable Direction dir) {
        this.dir = dir;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE == cap ? this.implContainer.cast() : LazyOptional.empty();
    }

    public FloatNBT serializeNBT() {
        return (FloatNBT)INSTANCE.writeNBT(this.implContainer.orElse((Object)new PersistentStackCapability()), this.dir);
    }

    public void deserializeNBT(FloatNBT nbt) {
        INSTANCE.readNBT(this.implContainer.orElse((Object)new PersistentStackCapability()), this.dir, (INBT)nbt);
    }

    public static PersistentStackCapabilityHandles getOrDefault(ItemStack stack, Direction side) {
        return (PersistentStackCapabilityHandles)stack.getCapability(INSTANCE, side).orElse((Object)new PersistentStackCapability());
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PersistentStackCapabilityHandles.class, (Capability.IStorage)new PersistentStackStorage((Lazy<Capability<PersistentStackCapabilityHandles>>)((Lazy)() -> INSTANCE)), PersistentStackCapability::new);
    }
}

