/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.event;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.tslat.aoa3.client.Keybinds;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.overlay.HelmetScreenRenderer;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.client.gui.overlay.ScreenOverlayRenderer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.HaloChangePacket;
import net.tslat.aoa3.common.packet.packets.LongReachItemHitPacket;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.mob.greckon.SilencerEntity;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.item.LongReachItem;
import net.tslat.aoa3.item.armour.ScreenOverlayArmour;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.library.misc.AoAHalos;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    public static int tick;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            ClientPlayerEntity player;
            if (++tick > 24000) {
                tick = 0;
            }
            if (ScreenOverlayRenderer.overlayTicks > 0) {
                --ScreenOverlayRenderer.overlayTicks;
            }
            if (RecoilRenderer.recoilTicksRemaining > 0) {
                --RecoilRenderer.recoilTicksRemaining;
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) == null) {
                return;
            }
            if (player.func_225608_bj_() && player.field_70122_E) {
                Item sniper = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
                if (sniper instanceof BaseSniper) {
                    ScopeOverlayRenderer.isScoped = true;
                    ScopeOverlayRenderer.scope = ((BaseSniper)sniper).getScopeType();
                } else {
                    ScopeOverlayRenderer.isScoped = false;
                }
            } else {
                ScopeOverlayRenderer.isScoped = false;
                if (ScopeOverlayRenderer.scope != null) {
                    RecoilRenderer.recoilTicks = 5;
                    RecoilRenderer.recoilTicksRemaining = 5;
                    RecoilRenderer.recoilAngle = 1.0f;
                    ScopeOverlayRenderer.scope = null;
                }
            }
            HelmetScreenRenderer.active = false;
            Item helmetItem = ((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b();
            if (!ScopeOverlayRenderer.isScoped && helmetItem instanceof ScreenOverlayArmour) {
                HelmetScreenRenderer.type = ((ScreenOverlayArmour)helmetItem).getOverlay();
                HelmetScreenRenderer.active = true;
            }
            if (!Minecraft.func_71410_x().func_71356_B()) {
                AoAScheduler.handleSyncScheduledTasks(++GlobalEvents.tick);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onLongReachSwing(InputEvent.MouseInputEvent ev) {
        if (ev.getAction() == 1 && ev.getButton() == 0 && Minecraft.func_71410_x().field_71462_r == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player != null && player.field_70170_p != null) {
                RayTraceResult ray;
                if (player.func_175149_v()) {
                    return;
                }
                ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
                if (stack.func_77973_b() instanceof LongReachItem && !player.func_184587_cr() && (ray = ClientEventHandler.getExtendedReachRayTrace(((LongReachItem)stack.func_77973_b()).getReach())) instanceof EntityRayTraceResult) {
                    AoAPackets.messageServer(new LongReachItemHitPacket(((EntityRayTraceResult)ray).func_216348_a().func_145782_y()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (((Boolean)AoAConfig.CLIENT.showWelcomeMessage.get()).booleanValue()) {
            if (Keybinds.keyAdventGui.getKey().func_197937_c() == -1) {
                ev.getPlayer().func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.login.welcome.alt", TextFormatting.GRAY));
            } else {
                ev.getPlayer().func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.login.welcome", TextFormatting.GRAY, Keybinds.keyAdventGui.func_197978_k()));
            }
        }
        if (ev.getPlayer().field_70170_p.func_201670_d()) {
            AoAPackets.INSTANCE.sendTo((Object)new HaloChangePacket((AoAHalos.Type.Choosable)((Object)AoAConfig.CLIENT.personalHaloPreference.get())), ((ClientPlayerEntity)ev.getPlayer()).field_71174_a.func_147298_b(), NetworkDirection.PLAY_TO_SERVER);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent ev) {
        if (ev.getEntity() instanceof PlayerEntity) {
            ScreenOverlayRenderer.overlayTicks = 0;
        }
    }

    @Nullable
    private static RayTraceResult getExtendedReachRayTrace(float reach) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity player = mc.func_175606_aa();
        if (player != null && player.field_70170_p != null) {
            AxisAlignedBB boundingBox;
            float partialTicks = mc.func_184121_ak();
            mc.field_147125_j = null;
            mc.field_71476_x = player.func_213324_a((double)reach, partialTicks, false);
            Vec3d eyePos = player.func_174824_e(partialTicks);
            double squareDistance = reach;
            squareDistance *= squareDistance;
            if (mc.field_71476_x != null) {
                squareDistance = mc.field_71476_x.func_216347_e().func_72436_e(eyePos);
            }
            Vec3d lookVec = player.func_70676_i(1.0f);
            Vec3d reachVec = eyePos.func_72441_c(lookVec.field_72450_a * (double)reach, lookVec.field_72448_b * (double)reach, lookVec.field_72449_c * (double)reach);
            EntityRayTraceResult trace = ProjectileHelper.func_221273_a((Entity)player, (Vec3d)eyePos, (Vec3d)reachVec, (AxisAlignedBB)(boundingBox = player.func_174813_aQ().func_216361_a(lookVec.func_186678_a((double)reach)).func_72314_b(1.0, 1.0, 1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)squareDistance);
            if (trace != null) {
                Entity entity2 = trace.func_216348_a();
                if (eyePos.func_72436_e(trace.func_216347_e()) < squareDistance || mc.field_71476_x == null) {
                    mc.field_71476_x = trace;
                    if (entity2 instanceof LivingEntity || entity2 instanceof ItemFrameEntity) {
                        mc.field_147125_j = entity2;
                    }
                }
            }
            if (mc.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY) {
                return mc.field_71476_x;
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void onSoundPlay(PlaySoundEvent ev) {
        ClientPlayerEntity player;
        if (SilencerEntity.isClientNearby && ((player = Minecraft.func_71410_x().field_71439_g) == null || player.field_70170_p.func_217357_a(SilencerEntity.class, player.func_174813_aQ().func_186662_g(8.0)).isEmpty())) {
            SilencerEntity.isClientNearby = false;
            Minecraft.func_71410_x().func_147118_V().func_184399_a(SoundCategory.MASTER, SilencerEntity.prevVolume);
        }
    }
}

