/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.base.AoAAmbientNPC;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.library.resourcemanager.BestiaryManager;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.skill.HunterUtil;
import org.apache.logging.log4j.Level;

@OnlyIn(value=Dist.CLIENT)
public class AdventGuiTabBestiary
extends Screen
implements IProgressMeter {
    private static final ResourceLocation iconsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/icons.png");
    private static final HashMap<String, Function<Entity, Tuple>> registeredEntryHandlers = new HashMap(1);
    private final HashMap<String, Entity> instancesMap = new HashMap();
    private StatisticsManager stats;
    private Object2IntMap<Stat<?>> statsMap;
    private BestiaryMenu scrollMenu;
    private ArrayList<EntityStats> statList;
    private ArrayList<EntityStats> filteredMobList;
    private boolean receivedStats = false;
    private int lastOpenIndex = -1;
    private int openEntryIndex = -1;
    private int openEntryHeight = 0;
    private float lastDistanceScrolled = 0.0f;
    private Entity openEntryInstance = null;
    private List<String> openEntryInfoLines = null;
    private List<String> openEntryStatsLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;
    protected TextFieldWidget searchField;

    protected AdventGuiTabBestiary() {
        super((ITextComponent)new TranslationTextComponent("gui.aoa3.adventGui.bestiary", new Object[0]));
    }

    protected void init() {
        this.receivedStats = false;
        this.openEntryIndex = -1;
        this.stats = this.getMinecraft().field_71439_g.func_146107_m();
        if (this.statsMap == null) {
            this.statsMap = (Object2IntMap)ObfuscationReflectionHelper.getPrivateValue(StatisticsManager.class, (Object)this.stats, (String)"field_150875_a");
        }
        if (this.scrollMenu == null) {
            this.scrollMenu = new BestiaryMenu(this.minecraft, AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, 0.45f);
        }
        this.searchField = new TextFieldWidget(this.font, AdventMainGui.scaledTabRootX + 20, AdventMainGui.scaledTabRootY, (int)((double)(this.width - 40) / 2.0), 15, "");
        this.searchField.func_146189_e(false);
        this.getMinecraft().func_147114_u().func_147297_a((IPacket)new CClientStatusPacket(CClientStatusPacket.State.REQUEST_STATS));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.scrollMenu.render(this.adjustedMouseX, this.adjustedMouseY, partialTicks);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseScroll(-1.0, -1.0, scrollAmount);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.scrollMenu != null) {
            this.scrollMenu.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(this.minecraft, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    public void func_193026_g() {
        HashMap<String, EntityStats> statsMap = new HashMap<String, EntityStats>();
        this.statList = new ArrayList();
        for (Object stat2 : this.statsMap.keySet()) {
            ResourceLocation registryName;
            if (!(stat2.func_197920_b() instanceof EntityType) || (registryName = ((EntityType)stat2.func_197920_b()).getRegistryName()) == null || !((Boolean)AoAConfig.CLIENT.thirdPartyBestiary.get()).booleanValue() && !registryName.func_110624_b().equals("aoa3")) continue;
            String registryNameString = registryName.toString();
            if (!statsMap.containsKey(registryNameString)) {
                statsMap.put(registryNameString, new EntityStats((Stat)stat2, stat2.func_197921_a() == Stats.field_199090_h));
                continue;
            }
            ((EntityStats)statsMap.get(registryNameString)).matchAndComplete(stat2);
        }
        for (Object stat2 : statsMap.values()) {
            if (!((EntityStats)stat2).hasKills()) continue;
            this.statList.add((EntityStats)stat2);
        }
        this.statList.sort(Comparator.comparing(stat -> ((EntityStats)stat).registryName.func_110623_a()));
        this.filteredMobList = (ArrayList)this.statList.clone();
        this.receivedStats = true;
    }

    public void onClose() {
        if (this.searchField != null && this.searchField.isFocused()) {
            this.searchField.func_146195_b(false);
        }
    }

    @Nullable
    private Entity getEntityFromStat(EntityStats stat) {
        String registryName = stat.registryName.toString();
        if (this.instancesMap.containsKey(registryName)) {
            return this.instancesMap.get(registryName);
        }
        try {
            Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(stat.registryName)).func_200721_a((World)this.minecraft.field_71439_g.field_213837_d);
            this.instancesMap.put(registryName, entity);
            return entity;
        }
        catch (Exception e) {
            Logging.logMessage(Level.DEBUG, "Unable to retrieve entity from entity type: " + registryName);
            return null;
        }
    }

    public boolean charTyped(char character, int arg) {
        if (this.searchField.isFocused()) {
            int searchTextLength = this.searchField.func_146179_b().length();
            if (this.searchField.charTyped(character, arg)) {
                if (this.searchField.func_146179_b().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.func_146193_g(NumberUtil.RGB(255, 255, 255));
                } else if (this.searchField.func_146179_b().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.func_146179_b().length());
                }
            }
            return true;
        }
        return super.charTyped(character, arg);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean success = super.keyPressed(keyCode, scanCode, modifiers);
        if (this.openEntryIndex < 0 && keyCode == 70 && AdventGuiTabBestiary.hasControlDown() && !AdventGuiTabBestiary.hasShiftDown() && !AdventGuiTabBestiary.hasAltDown()) {
            if (!this.searchField.func_146176_q()) {
                this.searchField.func_146189_e(true);
            }
            this.searchField.func_146195_b(true);
            return true;
        }
        if (this.searchField.isFocused()) {
            int searchTextLength = this.searchField.func_146179_b().length();
            if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
                if (this.searchField.func_146179_b().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.func_146193_g(NumberUtil.RGB(255, 255, 255));
                } else if (this.searchField.func_146179_b().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.func_146179_b().length());
                }
            }
            return true;
        }
        return success;
    }

    private void searchFilterBestiaryEntries(boolean additiveEdit) {
        String searchFilter;
        this.searchField.func_146193_g(NumberUtil.RGB(255, 255, 255));
        if (this.searchField.func_146179_b().isEmpty()) {
            this.filteredMobList = (ArrayList)this.statList.clone();
            return;
        }
        if (!additiveEdit || this.filteredMobList == null) {
            this.filteredMobList = (ArrayList)this.statList.clone();
        }
        if ((searchFilter = this.searchField.func_146179_b().toLowerCase()).startsWith("@")) {
            String modIdFilter = searchFilter.split("@", 2)[1].split(" ")[0];
            this.filteredMobList.removeIf(stat -> !((EntityStats)stat).registryName.func_110624_b().startsWith(modIdFilter));
            searchFilter = searchFilter.replace("@" + modIdFilter, "");
            if (searchFilter.startsWith(" ")) {
                searchFilter = searchFilter.substring(1);
            }
            if (searchFilter.isEmpty()) {
                if (this.filteredMobList.isEmpty()) {
                    this.searchField.func_146193_g(NumberUtil.RGB(255, 0, 0));
                }
                return;
            }
        }
        String searchedEntityName = searchFilter;
        this.filteredMobList.removeIf(stat -> {
            ResourceLocation registryName = ((EntityStats)stat).registryName;
            String entityName = LocaleUtil.getLocaleString("entity." + registryName.func_110624_b() + "." + registryName.func_110623_a()).replace("." + registryName.func_110624_b(), "");
            return !entityName.toLowerCase().contains(searchedEntityName);
        });
        if (this.filteredMobList.isEmpty()) {
            this.searchField.func_146193_g(NumberUtil.RGB(255, 0, 0));
        }
    }

    private void gatherEntityStats(EntityStats stat) {
        LivingEntity livingInstance;
        ResourceLocation registryName = stat.registryName;
        String entityModId = registryName.func_110624_b();
        this.openEntryInstance = this.getEntityFromStat(stat);
        this.openEntryStatsLines = new ArrayList<String>();
        this.openEntryInfoLines = new ArrayList<String>(0);
        LivingEntity livingEntity = livingInstance = this.openEntryInstance instanceof LivingEntity ? (LivingEntity)this.openEntryInstance : null;
        if (this.openEntryInstance != null) {
            if (registeredEntryHandlers.containsKey(entityModId)) {
                try {
                    Tuple entityData = registeredEntryHandlers.get(entityModId).apply(this.openEntryInstance);
                    this.openEntryStatsLines = (List)entityData.func_76341_a();
                    if (entityData.func_76340_b() != null && ((String)entityData.func_76340_b()).length() > 0) {
                        this.openEntryInfoLines = this.font.func_78271_c((String)entityData.func_76340_b(), 489);
                    }
                }
                catch (ClassCastException ex) {
                    Logging.logMessage(Level.WARN, "Mod '" + entityModId + "' provided invalid bestiary entry handler. Removing support. Report this to the mod author.");
                    registeredEntryHandlers.remove(entityModId);
                    this.openEntryIndex = -1;
                    this.openEntryHeight = 0;
                }
            } else {
                String bestiaryInfo;
                String attribute = "";
                String type = !this.openEntryInstance.func_184222_aU() ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.boss") : (this.openEntryInstance instanceof AoAMeleeMob ? (this.openEntryInstance instanceof AoARangedAttacker ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.hybrid") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.melee")) : (this.openEntryInstance instanceof AoARangedMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ranged") : (this.openEntryInstance instanceof AoAFlyingMeleeMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingMelee") : (this.openEntryInstance instanceof AoAFlyingRangedMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingRanged") : (this.openEntryInstance instanceof AnimalEntity ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.animal") : (this.openEntryInstance instanceof AoAAmbientNPC ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ambient") : (this.openEntryInstance instanceof AoATrader ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.trader") : (entityModId.equals("aoa3") ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.other") : (this.openEntryInstance instanceof IRangedAttackMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ranged") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.melee"))))))))));
                if (livingInstance != null) {
                    CreatureAttribute creatureAttribute = livingInstance.func_70668_bt();
                    if (creatureAttribute == CreatureAttribute.field_223224_c_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.arthropod");
                    } else if (creatureAttribute == CreatureAttribute.field_223225_d_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.illager");
                    } else if (creatureAttribute == CreatureAttribute.field_223223_b_) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.undead");
                    } else if (creatureAttribute == CreatureAttribute.field_223222_a_ || creatureAttribute == CreatureAttribute.field_203100_e) {
                        attribute = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.none");
                    }
                }
                this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type") + TextFormatting.RESET + " " + type);
                if (livingInstance != null && HunterUtil.isHunterCreature(livingInstance)) {
                    this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.hunterReq") + TextFormatting.RESET + " " + HunterUtil.getHunterLevel((LivingEntity)this.openEntryInstance));
                    this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.hunterXp") + TextFormatting.RESET + " " + HunterUtil.getHunterXp((LivingEntity)this.openEntryInstance));
                }
                this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute") + TextFormatting.RESET + " " + attribute);
                this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.size") + TextFormatting.RESET + " " + (float)((int)(this.openEntryInstance.func_213311_cf() * 1000.0f)) / 1000.0f + "x" + (float)((int)(this.openEntryInstance.func_213302_cg() * 1000.0f)) / 1000.0f);
                this.openEntryStatsLines.add("");
                if (livingInstance != null) {
                    IAttributeInstance attackAttribute;
                    this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.health") + TextFormatting.RESET + " " + livingInstance.func_110138_aP());
                    if (livingInstance.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() > 0.0) {
                        this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.armour") + TextFormatting.RESET + " " + livingInstance.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
                    }
                    if (livingInstance.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() > 0.0) {
                        this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.knockback") + TextFormatting.RESET + " " + livingInstance.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() * 100.0 + "%");
                    }
                    if ((attackAttribute = livingInstance.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null && attackAttribute.func_111126_e() > 0.0) {
                        this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.strength") + TextFormatting.RESET + " " + livingInstance.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    }
                    if (this.openEntryInstance instanceof AoARangedAttacker) {
                        if (this.openEntryInstance instanceof AoARangedMob) {
                            this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + TextFormatting.RESET + " " + ((AoARangedMob)this.openEntryInstance).getBaseProjectileDamage());
                        } else if (this.openEntryInstance instanceof AoAFlyingRangedMob) {
                            this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + TextFormatting.RESET + " " + ((AoAFlyingRangedMob)this.openEntryInstance).getBaseProjectileDamage());
                        }
                    }
                    this.openEntryStatsLines.add(TextFormatting.BOLD + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.speed") + TextFormatting.RESET + " " + (float)((int)(livingInstance.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1000.0)) / 1000.0f);
                }
                if ((bestiaryInfo = BestiaryManager.BESTIARY.get(registryName)) != null) {
                    this.openEntryInfoLines = this.font.func_78271_c(bestiaryInfo, 489);
                }
            }
        } else {
            this.openEntryIndex = -1;
            this.openEntryHeight = 0;
        }
    }

    public static void registerThirdPartyBestiaryHandler(String modId, Function<Entity, Tuple> entityHandlerFunction) {
        if (!modId.equalsIgnoreCase("aoa3")) {
            registeredEntryHandlers.put(modId, entityHandlerFunction);
        }
    }

    private class BestiaryMenu
    extends ScrollablePane {
        public BestiaryMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... renderingScale) {
            super(AdventGuiTabBestiary.this.minecraft, top, left, viewHeight, viewWidth, renderingScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabBestiary.this.receivedStats ? (AdventGuiTabBestiary.this.openEntryIndex < 0 ? (AdventGuiTabBestiary.this.filteredMobList.size() + AdventGuiTabBestiary.this.filteredMobList.size() % 2) * 100 + 20 : AdventGuiTabBestiary.this.openEntryHeight) : 0;
        }

        @Override
        public void drawPaneContents(int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            RenderSystem.pushMatrix();
            if (!AdventGuiTabBestiary.this.receivedStats) {
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.downloading"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, IProgressMeter.field_146510_b_[(int)(Util.func_211177_b() / 150L % (long)IProgressMeter.field_146510_b_.length)], left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f), 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            } else if (AdventGuiTabBestiary.this.filteredMobList.isEmpty()) {
                if (!AdventGuiTabBestiary.this.statList.isEmpty()) {
                    RenderUtil.drawColouredBox(left, AdventMainGui.scaledTabRootY, 0, 20, 20, -14671840);
                    AdventGuiTabBestiary.this.getMinecraft().func_110434_K().func_110577_a(iconsTextures);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.renderScaledCustomSizedTexture(left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                    if (AdventGuiTabBestiary.this.searchField.func_146176_q()) {
                        AdventGuiTabBestiary.this.searchField.x = (int)((double)(left + 20) / 2.0);
                        AdventGuiTabBestiary.this.searchField.y = (int)((double)AdventMainGui.scaledTabRootY / 2.0);
                        AdventGuiTabBestiary.this.searchField.setWidth((int)((double)(right - left - 40) / 2.0));
                        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
                        AdventGuiTabBestiary.this.searchField.render(AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.emptySearch"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
                } else {
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.empty"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
                }
            } else if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                for (int i = Math.max(0, (int)(scrollDistance / 200.0f) * 2); i * 100 <= bottom - top && i < AdventGuiTabBestiary.this.filteredMobList.size(); i += 2) {
                    EntityStats entityStat = (EntityStats)AdventGuiTabBestiary.this.filteredMobList.get(i);
                    ResourceLocation registryName = entityStat.registryName;
                    int rowTop = top + 20 + i * 100;
                    Entity entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    String entityName = entity != null ? ((EntityType)entityStat.killStat.func_197920_b()).func_212546_e().func_150254_d() : LocaleUtil.getLocaleString("entity." + registryName.func_110624_b() + "." + registryName.func_110623_a()).replace("." + registryName.func_110624_b(), "");
                    RenderUtil.drawColouredBox(left + 40, rowTop + 30, 0, 320, 150, -14671840);
                    if (entity != null) {
                        this.drawEntity(entity, left + 200, rowTop + 170, 50.0f);
                    }
                    RenderUtil.drawColouredBox(left + 40, rowTop, 0, 320, 30, -16711423);
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, entityName, left + 200, rowTop + 8, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    AdventGuiTabBestiary.this.getMinecraft().func_110434_K().func_110577_a(iconsTextures);
                    RenderSystem.enableAlphaTest();
                    RenderUtil.renderScaledCustomSizedTexture(left + 300, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(left + 43, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                    RenderSystem.disableAlphaTest();
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.killStat), true), left + 60, rowTop + 163, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.deathStat), true), left + 320, rowTop + 163, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    if (i + 1 >= AdventGuiTabBestiary.this.filteredMobList.size()) continue;
                    entityStat = (EntityStats)AdventGuiTabBestiary.this.filteredMobList.get(i + 1);
                    entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    entityName = entity != null ? entity.func_145748_c_().func_150254_d() : LocaleUtil.getLocaleString("entity." + entityStat.registryName.func_110624_b() + "." + entityStat.registryName.func_110623_a()).replace(".minecraft", "");
                    RenderUtil.drawColouredBox(right - 360, rowTop + 30, 0, 320, 150, -14671840);
                    if (entity != null) {
                        this.drawEntity(entity, right - 200, rowTop + 170, 50.0f);
                    }
                    RenderUtil.drawColouredBox(right - 360, rowTop, 0, 320, 30, -16711423);
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, entityName, right - 200, rowTop + 8, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    AdventGuiTabBestiary.this.getMinecraft().func_110434_K().func_110577_a(iconsTextures);
                    RenderSystem.enableAlphaTest();
                    RenderUtil.renderScaledCustomSizedTexture(right - 100, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(right - 357, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                    RenderSystem.disableAlphaTest();
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.killStat), true), right - 340, rowTop + 163, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.deathStat), true), right - 80, rowTop + 163, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                }
                RenderSystem.disableDepthTest();
                RenderUtil.drawColouredBox(left, AdventMainGui.scaledTabRootY, 0, 20, 20, -14671840);
                AdventGuiTabBestiary.this.getMinecraft().func_110434_K().func_110577_a(iconsTextures);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.renderScaledCustomSizedTexture(left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                if (AdventGuiTabBestiary.this.searchField.func_146176_q()) {
                    AdventGuiTabBestiary.this.searchField.x = (int)((double)(left + 20) / 2.0);
                    AdventGuiTabBestiary.this.searchField.y = (int)((double)AdventMainGui.scaledTabRootY / 2.0);
                    AdventGuiTabBestiary.this.searchField.setWidth((int)((double)(right - left - 40) / 2.0));
                    RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
                    AdventGuiTabBestiary.this.searchField.render(AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                    RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                RenderSystem.enableDepthTest();
            } else {
                int i;
                EntityStats entityStat = (EntityStats)AdventGuiTabBestiary.this.filteredMobList.get(AdventGuiTabBestiary.this.openEntryIndex);
                ResourceLocation registryName = entityStat.registryName;
                int n = AdventGuiTabBestiary.this.openEntryInfoLines.size();
                AdventGuiTabBestiary.this.font.getClass();
                AdventGuiTabBestiary.this.openEntryHeight = Math.max(this.viewHeight - 30, 320 + (int)((float)(n * 9) * 1.5f));
                RenderUtil.drawColouredBox(left, top + 30, 0, right - left, bottom - top, -14671840);
                RenderUtil.drawColouredBox(left, top, 0, right - left, 30, -16711423);
                String entityName = AdventGuiTabBestiary.this.openEntryInstance != null ? AdventGuiTabBestiary.this.openEntryInstance.func_200200_C_().func_150254_d() : LocaleUtil.getLocaleString("entity." + registryName.func_110624_b() + "." + registryName.func_110623_a()).replace(".minecraft", "");
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.font, entityName, left + (int)((float)this.viewWidth / 2.0f), top + 8, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                    this.drawEntity(AdventGuiTabBestiary.this.openEntryInstance, left + 200, top + 240, 75.0f);
                }
                AdventGuiTabBestiary.this.getMinecraft().func_110434_K().func_110577_a(iconsTextures);
                RenderSystem.enableAlphaTest();
                RenderUtil.renderScaledCustomSizedTexture(left + 425, top + 45, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                RenderUtil.renderScaledCustomSizedTexture(left + 425, top + 65, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 48.0f);
                RenderSystem.disableAlphaTest();
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, "X", right - 20, top + 5, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.killStat), true), left + 445, top + 48, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.font, NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityStat.deathStat), true), left + 445, top + 68, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.5f);
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryStatsLines.size(); ++i) {
                    AdventGuiTabBestiary.this.font.func_175063_a((String)AdventGuiTabBestiary.this.openEntryStatsLines.get(i), (float)((int)((float)(left + 425) / 1.5f)), (float)((int)((float)(top + 100 + 14 * i) / 1.5f)), NumberUtil.RGB(255, 255, 255));
                }
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryInfoLines.size(); ++i) {
                    AdventGuiTabBestiary.this.font.func_211126_b((String)AdventGuiTabBestiary.this.openEntryInfoLines.get(i), (float)((int)((float)(left + 20) / 1.5f)), (float)((int)((float)(top + 300 + i * 14) / 1.5f)), NumberUtil.RGB(255, 255, 255));
                }
            }
            RenderSystem.popMatrix();
        }

        @Override
        public void drawBackground() {
        }

        private void drawEntity(Entity entity, int posX, int posY, float scale) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
            RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
            MatrixStack matrix = new MatrixStack();
            Minecraft mc = Minecraft.func_71410_x();
            float sizeFactor = Math.max(entity.func_213311_cf(), entity.func_213302_cg());
            if ((double)sizeFactor > 2.5) {
                scale = (float)((double)scale / ((double)sizeFactor / 2.5));
            }
            matrix.func_227861_a_(0.0, 0.0, 1000.0);
            matrix.func_227862_a_(scale, scale, scale);
            Quaternion quaternion = Vector3f.field_229179_b_.func_229187_a_(180.0f);
            matrix.func_227863_a_(quaternion);
            entity.field_70173_aa = mc.field_71439_g.field_70173_aa;
            entity.field_70177_z = 0.0f;
            entity.field_70125_A = 0.0f;
            EntityRendererManager renderManager = mc.func_175598_ae();
            renderManager.func_178633_a(false);
            IRenderTypeBuffer.Impl renderBuffer = mc.func_228019_au_().func_228487_b_();
            renderManager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (IRenderTypeBuffer)renderBuffer, 0xF000F0);
            renderBuffer.func_228461_a_();
            renderManager.func_178633_a(true);
            RenderSystem.popMatrix();
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            super.handleMouseClick(mouseX, mouseY, button);
            if (!AdventGuiTabBestiary.this.receivedStats) {
                return false;
            }
            int relativeMouseX = (int)mouseX - this.left + 2;
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                if (relativeMouseX >= 0 && relativeMouseX <= 20 && mouseY - (double)this.top + 2.0 < 20.0) {
                    AdventGuiTabBestiary.this.searchField.func_146189_e(!AdventGuiTabBestiary.this.searchField.func_146176_q());
                    if (AdventGuiTabBestiary.this.searchField.func_146176_q()) {
                        AdventGuiTabBestiary.this.searchField.func_146195_b(true);
                    } else {
                        AdventGuiTabBestiary.this.searchField.func_146180_a("");
                        AdventGuiTabBestiary.this.searchFilterBestiaryEntries(false);
                    }
                } else if (AdventGuiTabBestiary.this.searchField.func_146176_q() && AdventGuiTabBestiary.this.searchField.mouseClicked((double)((int)((double)(relativeMouseX + this.left) / 2.0)), (double)((int)((mouseY - 2.0) / 2.0)), 0)) {
                    return true;
                }
                if (relativeMouseX < 40 || relativeMouseX > this.right - this.left - 40) {
                    return false;
                }
            }
            int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
            int relativeMouseY = (int)mouseY - newTop + 2;
            if (mouseY - (double)this.top < 0.0 || mouseY > (double)(this.top + this.viewHeight)) {
                return false;
            }
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                float preIndexY;
                int selectedIndex = -1;
                if (relativeMouseX < 360) {
                    float preIndexY2 = (float)relativeMouseY / 200.0f;
                    if ((double)(preIndexY2 - (float)((int)preIndexY2)) > 0.11) {
                        selectedIndex = 2 * (int)preIndexY2;
                    }
                } else if (relativeMouseX > this.right - this.left - 360 && (double)((preIndexY = (float)relativeMouseY / 200.0f) - (float)((int)preIndexY)) > 0.11) {
                    selectedIndex = 1 + (int)preIndexY * 2;
                }
                if (selectedIndex >= 0 && AdventGuiTabBestiary.this.filteredMobList.size() > selectedIndex) {
                    AdventGuiTabBestiary.this.openEntryIndex = selectedIndex;
                    AdventGuiTabBestiary.this.openEntryHeight = 600;
                    AdventGuiTabBestiary.this.lastDistanceScrolled = this.distanceScrolled;
                    this.distanceScrolled = 0.0f;
                    if (AdventGuiTabBestiary.this.lastOpenIndex != selectedIndex) {
                        if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                            AdventGuiTabBestiary.this.openEntryInstance.func_70106_y();
                        }
                        AdventGuiTabBestiary.this.gatherEntityStats((EntityStats)AdventGuiTabBestiary.this.filteredMobList.get(selectedIndex));
                    }
                    AdventGuiTabBestiary.this.lastOpenIndex = selectedIndex;
                    AdventGuiTabBestiary.this.searchField.func_146189_e(false);
                }
            } else if (relativeMouseY <= 30) {
                AdventGuiTabBestiary.this.lastOpenIndex = AdventGuiTabBestiary.this.openEntryIndex;
                AdventGuiTabBestiary.this.openEntryIndex = -1;
                AdventGuiTabBestiary.this.openEntryHeight = 0;
                this.distanceScrolled = AdventGuiTabBestiary.this.lastDistanceScrolled;
            }
            return true;
        }
    }

    private static class EntityStats {
        @Nonnull
        private final ResourceLocation registryName;
        private Stat<EntityType<?>> killStat = null;
        private Stat<EntityType<?>> deathStat = null;

        private EntityStats(Stat<EntityType<?>> stat, boolean killStat) {
            this.registryName = ((EntityType)stat.func_197920_b()).getRegistryName();
            if (killStat) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private void matchAndComplete(Stat<EntityType<?>> stat) {
            if (this.killStat == null) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private boolean hasKills() {
            return this.killStat != null;
        }

        private int getKills(StatisticsManager statsManager) {
            return statsManager.func_77444_a(this.killStat);
        }

        private int getDeaths(StatisticsManager statsManager) {
            return this.deathStat != null ? statsManager.func_77444_a(this.deathStat) : 0;
        }
    }
}

