/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.library.resourcemanager.GuidesManager;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class AdventGuiTabGuides
extends Screen {
    private BundlesMenu scrollMenu;
    private int openBundleIndex = -1;
    private long lastSelectionTime = 0L;
    private int openBundleHeight = 0;
    private List<String> openBundleLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;

    protected AdventGuiTabGuides() {
        super((ITextComponent)new TranslationTextComponent("gui.aoa3.adventGui.guides", new Object[0]));
    }

    protected void init() {
        if (this.scrollMenu == null) {
            this.scrollMenu = new BundlesMenu(this.getMinecraft(), AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, 0.45f);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        if (this.scrollMenu != null) {
            this.scrollMenu.render(this.adjustedMouseX, this.adjustedMouseY, partialTicks);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseScroll(this.adjustedMouseX, this.adjustedMouseY, scrollAmount);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseReleased(this.adjustedMouseX, this.adjustedMouseY, button);
        }
        return false;
    }

    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(mc, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    private class BundlesMenu
    extends ScrollablePane {
        public BundlesMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... currentScale) {
            super(mc, top, left, viewHeight, viewWidth, currentScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabGuides.this.openBundleIndex < 0 ? GuidesManager.GUIDES.size() * 30 : 30 + AdventGuiTabGuides.this.openBundleHeight;
        }

        @Override
        public void drawPaneContents(int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            int timeAdjustedTop = 0;
            float selectedPercentSwitched = 0.0f;
            if (AdventGuiTabGuides.this.openBundleIndex >= 0) {
                selectedPercentSwitched = Math.min(1.0f, (float)(System.currentTimeMillis() - AdventGuiTabGuides.this.lastSelectionTime) / 400.0f);
                timeAdjustedTop = top + (int)((float)(AdventGuiTabGuides.this.openBundleIndex * 20) * (1.0f - selectedPercentSwitched));
            }
            if (timeAdjustedTop != top) {
                for (int i = Math.max(0, (int)(scrollDistance / 30.0f)); i * 30 <= bottom - top && i < GuidesManager.GUIDES.size(); ++i) {
                    GuidesManager.Guide guide = GuidesManager.GUIDES.get(i);
                    int rowTop = top + i * 30;
                    int rowBottom = rowTop + 30;
                    RenderUtil.drawColouredBox(left, rowTop, 0, right - left, rowBottom - rowTop, i % 2 == 0 ? -16711423 : -14671840);
                    RenderUtil.drawCenteredScaledString(AdventGuiTabGuides.this.font, guide.title, left + (int)((float)this.viewWidth / 2.0f), rowTop + 8, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabGuides.this.font, "V", left + 5, rowTop + 18, 1.5f, NumberUtil.RGB(181, 181, 181), RenderUtil.StringRenderType.OUTLINED);
                    RenderUtil.drawScaledString(AdventGuiTabGuides.this.font, "V", right - 20, rowTop + 18, 1.5f, NumberUtil.RGB(181, 181, 181), RenderUtil.StringRenderType.OUTLINED);
                }
            }
            if (AdventGuiTabGuides.this.openBundleIndex >= 0) {
                GuidesManager.Guide guide = GuidesManager.GUIDES.get(AdventGuiTabGuides.this.openBundleIndex);
                if (AdventGuiTabGuides.this.openBundleLines == null) {
                    AdventGuiTabGuides.this.openBundleLines = AdventGuiTabGuides.this.font.func_78271_c(guide.content, (int)((float)(this.viewWidth - 30) / 1.5f));
                    float f = AdventGuiTabGuides.this.openBundleLines.size();
                    AdventGuiTabGuides.this.font.getClass();
                    AdventGuiTabGuides.this.openBundleHeight = Math.max(this.viewHeight - 30, 25 + (int)(f * (9.0f * 1.5f)));
                }
                int timeAdjustedBottom = (int)((float)(timeAdjustedTop + 30) + (float)AdventGuiTabGuides.this.openBundleHeight * selectedPercentSwitched);
                RenderUtil.drawColouredBox(left, timeAdjustedTop, 0, right - left, timeAdjustedBottom - timeAdjustedTop + 30, AdventGuiTabGuides.this.openBundleIndex % 2 == 0 ? -16711423 : -14671840);
                RenderUtil.drawCenteredScaledString(AdventGuiTabGuides.this.font, guide.title, left + (int)((float)this.viewWidth / 2.0f), timeAdjustedTop + 8, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabGuides.this.font, "^", left + 5, timeAdjustedTop + 18, 1.5f, NumberUtil.RGB(181, 181, 181), RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawScaledString(AdventGuiTabGuides.this.font, "^", right - 20, timeAdjustedTop + 18, 1.5f, NumberUtil.RGB(181, 181, 181), RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawColouredBox(left, timeAdjustedTop + 30, 0, right - left, timeAdjustedBottom - timeAdjustedTop, -11513776);
                if (selectedPercentSwitched == 1.0f) {
                    int lineOffset = 0;
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.5f);
                    for (String s : AdventGuiTabGuides.this.openBundleLines) {
                        AdventGuiTabGuides.this.font.func_211126_b(s, (float)((int)((float)(left + 20) / 1.5f)), (float)((int)((float)(top + 30 + lineOffset) / 1.5f)), NumberUtil.RGB(255, 255, 255));
                        lineOffset += 14;
                    }
                    RenderSystem.popMatrix();
                }
            }
        }

        @Override
        public void drawBackground() {
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            super.handleMouseClick(mouseX, mouseY, button);
            int relativeMouseX = (int)mouseX - this.left + 2;
            if (relativeMouseX < 0 || relativeMouseX > this.viewWidth - 6) {
                return false;
            }
            int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
            int relativeMouseY = (int)mouseY - newTop + 2;
            if (mouseY - (double)this.top < 0.0 || mouseY > (double)(this.top + this.viewHeight)) {
                return false;
            }
            if (AdventGuiTabGuides.this.openBundleIndex < 0) {
                int selectedIndex = relativeMouseY / 30;
                if (GuidesManager.GUIDES.size() > selectedIndex) {
                    AdventGuiTabGuides.this.openBundleIndex = selectedIndex;
                    AdventGuiTabGuides.this.lastSelectionTime = System.currentTimeMillis();
                    AdventGuiTabGuides.this.openBundleHeight = 600;
                    this.distanceScrolled = 0.0f;
                }
            } else if (relativeMouseY <= 30) {
                AdventGuiTabGuides.this.openBundleIndex = -1;
                AdventGuiTabGuides.this.openBundleHeight = 0;
                AdventGuiTabGuides.this.openBundleLines = null;
            }
            return true;
        }
    }
}

