/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class AdventGuiTabHelp
extends Screen {
    private int tipNumber = RandomUtil.randomNumberUpTo(14);

    protected AdventGuiTabHelp() {
        super((ITextComponent)new TranslationTextComponent("gui.aoa3.adventGui.help", new Object[0]));
    }

    protected void init() {
        String wikiDownloadLink;
        String wikiLink;
        String language = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
        if (language.equals("zh_cn") || language.equals("zh_tw")) {
            wikiLink = "https://adventofascension-zh.gamepedia.com/Advent_of_Ascension_Wiki";
            wikiDownloadLink = "https://adventofascension-zh.gamepedia.com/%E4%B8%8B%E8%BD%BD";
        } else {
            wikiLink = "https://adventofascension.gamepedia.com/Advent_of_Ascension_Wiki";
            wikiDownloadLink = "https://adventofascension.gamepedia.com/Download";
        }
        this.addButton(new ThemeButton(640, 35, 30, 40));
        this.addButton(new WebLinkButton(this.getMinecraft(), 640, 130, 76, 18, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.linkDiscord"), this.stringToURI("https://discord.gg/DNYqNNq")));
        this.addButton(new WebLinkButton(this.getMinecraft(), 640, 170, 108, 18, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.linkWiki"), this.stringToURI(wikiLink)));
        this.addButton(new WebLinkButton(this.getMinecraft(), 640, 210, 60, 18, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.linkGithub"), this.stringToURI("https://github.com/Tslat/Advent-Of-Ascension")));
        this.addButton(new WebLinkButton(this.getMinecraft(), 640, 250, 80, 18, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.linkPatreon"), this.stringToURI("https://www.patreon.com/Tslat")));
        this.addButton(new WebLinkButton(this.getMinecraft(), 640, 290, 68, 18, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.linkUpdate"), this.stringToURI(wikiDownloadLink)));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderUtil.drawVerticalGradient(AdventMainGui.scaledTabRootX + 35, AdventMainGui.scaledTabRootY + 55, 0, 570, 225, -1072689136, -804253680);
        RenderUtil.drawCenteredScaledString(this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.theme"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 10, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawCenteredScaledString(this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.links"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 100, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawScaledString(this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.title"), AdventMainGui.scaledTabRootX + 80, AdventMainGui.scaledTabRootY + 25, 2.5f, NumberUtil.RGB(239, 137, 119), RenderUtil.StringRenderType.OUTLINED);
        RenderSystem.scalef((float)1.5625f, (float)1.5625f, (float)1.5625f);
        this.font.func_78279_b(LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.description").replace("<br>", "\n"), (int)((float)(AdventMainGui.scaledTabRootX + 40) / 1.5625f), (int)((float)(AdventMainGui.scaledTabRootY + 60) / 1.5625f), 360, NumberUtil.RGB(255, 255, 255));
        RenderSystem.scalef((float)0.64f, (float)0.64f, (float)0.64f);
        RenderUtil.drawScaledString(this.font, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.tip", LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.tip." + this.tipNumber)), AdventMainGui.scaledTabRootX + 30, AdventMainGui.scaledTabRootY + 310, 1.8f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        super.render(mouseX, mouseY, partialTicks);
    }

    private static void openURL(URI url) {
        Util.func_110647_a().func_195642_a(url);
    }

    @Nullable
    private URI stringToURI(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static class ThemeButton
    extends Widget {
        public ThemeButton(int x, int y, int width, int height) {
            super(x, y, width, height, (String)AoAConfig.CLIENT.adventGuiTheme.get());
        }

        public void onClick(double mouseX, double mouseY) {
            if (++AdventMainGui.currentTextureIndex == AdventMainGui.textures.size()) {
                AdventMainGui.currentTextureIndex = 0;
            }
            AdventMainGui.changeTheme();
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(AdventMainGui.textures.get((int)AdventMainGui.currentTextureIndex).menuButtonTexture);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.x, this.y);
                this.setMessage(((String)AoAConfig.CLIENT.adventGuiTheme.get()).replace("_", " "));
                this.width = (int)Math.max((float)(this.width - 10), 10.0f + (float)mc.field_71466_p.func_78256_a(this.getMessage()) * 1.5f);
                RenderUtil.renderScaledCustomSizedTexture(AdventMainGui.scaledTabRootX + this.x, AdventMainGui.scaledTabRootY + this.y, 0.0f, this.getYImage(this.isHovered) == 2 ? 60 : 120, 180.0f, 60.0f, this.width, this.height, 180.0f, 180.0f);
                int stringColour = 0xE0E0E0;
                if (this.getFGColor() != 0) {
                    stringColour = this.getFGColor();
                } else if (!this.active) {
                    stringColour = 0xA0A0A0;
                } else if (this.isHovered) {
                    stringColour = 0xFFFFA0;
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.getMessage(), (int)((float)(AdventMainGui.scaledTabRootX + this.x) + (float)this.width / 2.0f), (int)((double)(AdventMainGui.scaledTabRootY + this.y) + (double)this.height / 2.5), 1.5f, stringColour, RenderUtil.StringRenderType.DROP_SHADOW);
            }
        }

        protected boolean clicked(double p_clicked_1_, double p_clicked_3_) {
            return this.active && this.isHovered;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.width) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.height) * 0.45f);
        }
    }

    private static class WebLinkButton
    extends Widget {
        private final URI url;

        public WebLinkButton(Minecraft mc, int x, int y, int width, int height, String name, URI link) {
            super(x, y, width, height, name);
            this.url = link;
            if (this.url == null) {
                this.active = false;
                this.visible = false;
            } else {
                this.width = (int)((float)mc.field_71466_p.func_78256_a(this.getMessage()) * 2.0f);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            AdventGuiTabHelp.openURL(this.url);
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                Minecraft mc = Minecraft.func_71410_x();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.x, this.y);
                int stringColour = NumberUtil.RGB(239, 137, 119);
                if (this.isHovered) {
                    stringColour = NumberUtil.RGB(247, 239, 0);
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.getMessage(), (int)((float)(AdventMainGui.scaledTabRootX + this.x) + (float)this.width / 2.0f), AdventMainGui.scaledTabRootY + this.y, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
            }
        }

        protected boolean clicked(double p_clicked_1_, double p_clicked_3_) {
            return this.active && this.isHovered;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.width) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.height) * 0.45f);
        }
    }
}

