/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ExpeditionTogglePacket;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.animal.SpearmintSnailEntity;
import net.tslat.aoa3.entity.mob.abyss.OcculentEntity;
import net.tslat.aoa3.entity.mob.candyland.GingerbreadManEntity;
import net.tslat.aoa3.entity.mob.celeve.BoboEntity;
import net.tslat.aoa3.entity.mob.celeve.ChockoEntity;
import net.tslat.aoa3.entity.mob.celeve.KrankyEntity;
import net.tslat.aoa3.entity.mob.celeve.StickyEntity;
import net.tslat.aoa3.entity.mob.celeve.StitchesEntity;
import net.tslat.aoa3.entity.mob.misc.SeaSkeletonEntity;
import net.tslat.aoa3.entity.mob.overworld.AncientGolemEntity;
import net.tslat.aoa3.entity.mob.overworld.BruteEntity;
import net.tslat.aoa3.entity.mob.overworld.BugeyeEntity;
import net.tslat.aoa3.entity.mob.overworld.ChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.CyclopsEntity;
import net.tslat.aoa3.entity.mob.overworld.DesertChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.FacelessRunnerEntity;
import net.tslat.aoa3.entity.mob.overworld.GruntEntity;
import net.tslat.aoa3.entity.mob.overworld.HillChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.SeaChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.SeaTrollEntity;
import net.tslat.aoa3.entity.mob.overworld.ShadeEntity;
import net.tslat.aoa3.entity.mob.overworld.ShadowEntity;
import net.tslat.aoa3.entity.mob.overworld.SnowChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.SwampChargerEntity;
import net.tslat.aoa3.entity.mob.overworld.VoidChargerEntity;
import net.tslat.aoa3.entity.mob.precasia.EliteSkelePigEntity;
import net.tslat.aoa3.entity.mob.shyrelands.ArcwormEntity;
import net.tslat.aoa3.entity.mob.shyrelands.ShyreTrollEntity;
import net.tslat.aoa3.entity.mob.voxponds.AlarmoEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

@OnlyIn(value=Dist.CLIENT)
public class AdventGuiTabPlayer
extends Screen {
    private static final ResourceLocation resourcesTextures = new ResourceLocation("aoa3", "textures/gui/maingui/resources.png");
    private static final ResourceLocation skillsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/skills.png");
    private static int levelAlchemy = 1;
    private static float xpAlchemy = 0.0f;
    private static int percentCompleteAlchemy = 0;
    private static int levelAnima = 1;
    private static float xpAnima = 0.0f;
    private static int percentCompleteAnima = 0;
    private static int levelAugury = 1;
    private static float xpAugury = 0.0f;
    private static int percentCompleteAugury = 0;
    private static int levelButchery = 1;
    private static float xpButchery = 0.0f;
    private static int percentCompleteButchery = 0;
    private static int levelCreation = 1;
    private static float xpCreation = 0.0f;
    private static int percentCompleteCreation = 0;
    private static int levelEngineering = 1;
    private static float xpEngineering = 0.0f;
    private static int percentCompleteEngineering = 0;
    private static int levelExpedition = 1;
    private static float xpExpedition = 0.0f;
    private static int percentCompleteExpedition = 0;
    private static int optExpedition = 0;
    private static int levelExtraction = 1;
    private static float xpExtraction = 0.0f;
    private static int percentCompleteExtraction = 0;
    private static int levelForaging = 1;
    private static float xpForaging = 0.0f;
    private static int percentCompleteForaging = 0;
    private static int levelHauling = 1;
    private static float xpHauling = 0.0f;
    private static int percentCompleteHauling = 0;
    private static int levelHunter = 1;
    private static float xpHunter = 0.0f;
    private static int percentCompleteHunter = 0;
    private static int levelInfusion = 1;
    private static float xpInfusion = 0.0f;
    private static int percentCompleteInfusion = 0;
    private static int levelInnervation = 1;
    private static float xpInnervation = 0.0f;
    private static int percentCompleteInnervation = 0;
    private static int levelLogging = 1;
    private static float xpLogging = 0.0f;
    private static int percentCompleteLogging = 0;
    private static int levelRunation = 1;
    private static float xpRunation = 0.0f;
    private static int percentCompleteRunation = 0;
    public static int tributeErebon = 0;
    public static int tributeLuxon = 0;
    public static int tributePluton = 0;
    public static int tributeSelyan = 0;
    public static float resourceEnergy = 0.0f;
    public static float resourceCreation = 0.0f;
    public static float resourceSoul = 0.0f;
    public static float resourceRage = 0.0f;
    private int adjustedMouseX;
    private int adjustedMouseY;
    private LivingEntity entityToRender = null;

    protected AdventGuiTabPlayer() {
        super((ITextComponent)new TranslationTextComponent("gui.aoa3.adventGui.stats", new Object[0]));
    }

    protected void init() {
        this.setRenderEntity();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.drawPlayerBox(AdventMainGui.scaledTabRootX + 63, AdventMainGui.scaledTabRootY + 330, mouseX, mouseY, 66);
        if (((Boolean)AoAConfig.COMMON.resourcesEnabled.get()).booleanValue()) {
            this.renderResources();
        }
        if (((Boolean)AoAConfig.COMMON.skillsEnabled.get()).booleanValue()) {
            this.renderSkills();
        }
    }

    private void renderResources() {
        int x = AdventMainGui.scaledTabRootX + 15;
        int y = AdventMainGui.scaledTabRootY + 20;
        float percentComplete = (float)tributeSelyan / 200.0f;
        Minecraft mc = Minecraft.func_71410_x();
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("gui.aoa3.adventGui.stats.tribute"), x + 50, y - 15, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        mc.func_110434_K().func_110577_a(resourcesTextures);
        RenderUtil.renderScaledCustomSizedTexture(x, y, 0.0f, 0.0f, 100.0f, 30.0f, 100.0, 30.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x, y, 0.0f, percentComplete == 1.0f ? 60.0f : 30.0f, percentComplete * 100.0f, 30.0f, percentComplete * 100.0f, 30.0, 400.0f, 590.0f);
        percentComplete = (float)tributeLuxon / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x, y + 30, 100.0f, 0.0f, 100.0f, 30.0f, 100.0, 30.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x, y + 30, 100.0f, percentComplete == 1.0f ? 60.0f : 30.0f, percentComplete * 100.0f, 30.0f, percentComplete * 100.0f, 30.0, 400.0f, 590.0f);
        percentComplete = (float)tributeErebon / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x, y + 60, 200.0f, 0.0f, 100.0f, 30.0f, 100.0, 30.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x, y + 60, 200.0f, percentComplete == 1.0f ? 60.0f : 30.0f, percentComplete * 100.0f, 30.0f, percentComplete * 100.0f, 30.0, 400.0f, 590.0f);
        percentComplete = (float)tributePluton / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x, y + 90, 300.0f, 0.0f, 100.0f, 30.0f, 100.0, 30.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x, y + 90, 300.0f, percentComplete == 1.0f ? 60.0f : 30.0f, percentComplete * 100.0f, 30.0f, percentComplete * 100.0f, 30.0, 400.0f, 590.0f);
        percentComplete = resourceRage / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y, 0.0f, 190.0f, 50.0f, 50.0f, 62.0, 62.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y, resourceRage >= 150.0f ? 50.0f : 0.0f, 240.0f, percentComplete * 50.0f, 50.0f, percentComplete * 62.0f, 62.0, 400.0f, 590.0f);
        percentComplete = resourceEnergy / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 82, 0.0f, 90.0f, 50.0f, 50.0f, 62.0, 62.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 82, 0.0f, 140.0f, percentComplete * 50.0f, 50.0f, percentComplete * 62.0f, 62.0, 400.0f, 590.0f);
        percentComplete = resourceCreation / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 164, 0.0f, 290.0f, 50.0f, 50.0f, 62.0, 62.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 164, 0.0f, 340.0f, percentComplete * 50.0f, 50.0f, percentComplete * 62.0f, 62.0, 400.0f, 590.0f);
        percentComplete = resourceSoul / 200.0f;
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 246, 0.0f, 390.0f, 50.0f, 50.0f, 62.0, 62.0, 400.0f, 590.0f);
        RenderUtil.renderScaledCustomSizedTexture(x + 135, y + 246, 0.0f, 440.0f, percentComplete * 50.0f, 50.0f, percentComplete * 62.0f, 62.0, 400.0f, 590.0f);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("deities.selyan.name"), x + 50, y + 11, 1.25f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("deities.luxon.name"), x + 50, y + 41, 1.25f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("deities.erebon.name"), x + 50, y + 71, 1.25f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("deities.pluton.name"), x + 50, y + 101, 1.25f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.NORMAL);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("resources.rage.name"), x + 166, y - 15, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("resources.energy.name"), x + 166, y + 67, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("resources.creation.name"), x + 166, y + 149, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("resources.soul.name"), x + 166, y + 231, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, (int)resourceRage + "/" + 200, x + 166, y + 40, 1.125f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, (int)resourceEnergy + "/" + 200, x + 166, y + 122, 1.125f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, NumberUtil.floorAndAppendSuffix(resourceCreation, true) + "/" + NumberUtil.floorAndAppendSuffix(200.0f, true), x + 166, y + 204, 1.125f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, NumberUtil.floorAndAppendSuffix(resourceSoul, true) + "/" + NumberUtil.floorAndAppendSuffix(200.0f, true), x + 166, y + 286, 1.125f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
    }

    private void renderSkills() {
        int x;
        int y;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(skillsTextures);
        RenderSystem.enableAlphaTest();
        for (Skills skill : Skills.values()) {
            y = AdventMainGui.scaledTabRootY + 20 + (int)(Math.floor((float)skill.id / 5.0f) * 112.0);
            x = AdventMainGui.scaledTabRootX + 170 + 100 * (1 + skill.id % 5);
            int progressBarPercent = 0;
            int uvX = 0;
            int uvY = 0;
            int optionalUvX = -1;
            int optionalUvY = -1;
            block0 : switch (skill) {
                case ALCHEMY: {
                    progressBarPercent = percentCompleteAlchemy;
                    uvX = 0;
                    uvY = levelAlchemy >= 100 ? 50 : 0;
                    break;
                }
                case ANIMA: {
                    progressBarPercent = percentCompleteAnima;
                    uvX = 50;
                    uvY = levelAnima >= 100 ? 50 : 0;
                    break;
                }
                case AUGURY: {
                    progressBarPercent = percentCompleteAugury;
                    uvX = 100;
                    uvY = levelAugury >= 100 ? 50 : 0;
                    break;
                }
                case BUTCHERY: {
                    progressBarPercent = percentCompleteButchery;
                    uvX = 150;
                    uvY = levelButchery >= 100 ? 50 : 0;
                    break;
                }
                case CREATION: {
                    progressBarPercent = percentCompleteCreation;
                    uvX = 200;
                    uvY = levelCreation >= 100 ? 50 : 0;
                    break;
                }
                case ENGINEERING: {
                    progressBarPercent = percentCompleteEngineering;
                    uvX = 250;
                    uvY = levelEngineering >= 100 ? 50 : 0;
                    break;
                }
                case EXPEDITION: {
                    progressBarPercent = percentCompleteExpedition;
                    uvX = 300;
                    uvY = levelExpedition >= 100 ? 50 : 0;
                    switch (optExpedition % 4) {
                        case 1: {
                            optionalUvX = 300;
                            optionalUvY = 100;
                            break block0;
                        }
                        case 2: {
                            optionalUvX = 324;
                            optionalUvY = 100;
                            break block0;
                        }
                        case 3: {
                            optionalUvX = 348;
                            optionalUvY = 100;
                            break block0;
                        }
                    }
                    break;
                }
                case EXTRACTION: {
                    progressBarPercent = percentCompleteExtraction;
                    uvX = 350;
                    uvY = levelExtraction >= 100 ? 50 : 0;
                    break;
                }
                case FORAGING: {
                    progressBarPercent = percentCompleteForaging;
                    uvX = 400;
                    uvY = levelForaging >= 100 ? 50 : 0;
                    break;
                }
                case HAULING: {
                    progressBarPercent = percentCompleteHauling;
                    uvX = 0;
                    uvY = 100 + (levelHauling >= 100 ? 50 : 0);
                    break;
                }
                case HUNTER: {
                    progressBarPercent = percentCompleteHunter;
                    uvX = 50;
                    uvY = 100 + (levelHunter >= 100 ? 50 : 0);
                    break;
                }
                case INFUSION: {
                    progressBarPercent = percentCompleteInfusion;
                    uvX = 100;
                    uvY = 100 + (levelInfusion >= 100 ? 50 : 0);
                    break;
                }
                case INNERVATION: {
                    progressBarPercent = percentCompleteInnervation;
                    uvX = 150;
                    uvY = 100 + (levelInnervation >= 100 ? 50 : 0);
                    break;
                }
                case LOGGING: {
                    progressBarPercent = percentCompleteLogging;
                    uvX = 200;
                    uvY = 100 + (levelLogging >= 100 ? 50 : 0);
                    break;
                }
                case RUNATION: {
                    progressBarPercent = percentCompleteRunation;
                    uvX = 250;
                    uvY = 100 + (levelRunation >= 100 ? 50 : 0);
                }
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.renderScaledCustomSizedTexture(x, y, uvX, uvY, 50.0f, 50.0f, 62.0, 62.0, 450.0f, 240.0f);
            RenderUtil.renderScaledCustomSizedTexture(x, y + 50, 0.0f, 200.0f, 100.0f, 20.0f, 62.0, 13.0, 450.0f, 240.0f);
            RenderUtil.renderScaledCustomSizedTexture(x, y + 50, 0.0f, 220.0f, progressBarPercent, 20.0f, (float)progressBarPercent / 100.0f * 62.0f, 13.0, 450.0f, 240.0f);
            if (optionalUvX < 0) continue;
            RenderUtil.renderScaledCustomSizedTexture(x + 38, y, optionalUvX, optionalUvY, 24.0f, 24.0f, 24.0, 24.0, 450.0f, 240.0f);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Skills skill : Skills.values()) {
            y = AdventMainGui.scaledTabRootY + 20 + (int)(Math.floor((float)skill.id / 5.0f) * 112.0);
            x = AdventMainGui.scaledTabRootX + 170 + 100 * (1 + skill.id % 5);
            int lvl = 1;
            float xp = 0.0f;
            boolean hitXpCap = false;
            String skillName = "";
            switch (skill) {
                case ALCHEMY: {
                    skillName = LocaleUtil.getLocaleString("skills.alchemy.name");
                    lvl = levelAlchemy;
                    xp = xpAlchemy;
                    break;
                }
                case ANIMA: {
                    skillName = LocaleUtil.getLocaleString("skills.anima.name");
                    lvl = levelAnima;
                    xp = xpAnima;
                    break;
                }
                case AUGURY: {
                    skillName = LocaleUtil.getLocaleString("skills.augury.name");
                    lvl = levelAugury;
                    xp = xpAugury;
                    break;
                }
                case BUTCHERY: {
                    skillName = LocaleUtil.getLocaleString("skills.butchery.name");
                    lvl = levelButchery;
                    xp = xpButchery;
                    break;
                }
                case CREATION: {
                    skillName = LocaleUtil.getLocaleString("skills.creation.name");
                    lvl = levelCreation;
                    xp = xpCreation;
                    break;
                }
                case ENGINEERING: {
                    skillName = LocaleUtil.getLocaleString("skills.engineering.name");
                    lvl = levelEngineering;
                    xp = xpEngineering;
                    break;
                }
                case EXPEDITION: {
                    skillName = LocaleUtil.getLocaleString("skills.expedition.name");
                    lvl = levelExpedition;
                    xp = xpExpedition;
                    break;
                }
                case EXTRACTION: {
                    skillName = LocaleUtil.getLocaleString("skills.extraction.name");
                    lvl = levelExtraction;
                    xp = xpExtraction;
                    break;
                }
                case FORAGING: {
                    skillName = LocaleUtil.getLocaleString("skills.foraging.name");
                    lvl = levelForaging;
                    xp = xpForaging;
                    break;
                }
                case HAULING: {
                    skillName = LocaleUtil.getLocaleString("skills.hauling.name");
                    lvl = levelHauling;
                    xp = xpHauling;
                    break;
                }
                case HUNTER: {
                    skillName = LocaleUtil.getLocaleString("skills.hunter.name");
                    lvl = levelHunter;
                    xp = xpHunter;
                    break;
                }
                case INFUSION: {
                    skillName = LocaleUtil.getLocaleString("skills.infusion.name");
                    lvl = levelInfusion;
                    xp = xpInfusion;
                    break;
                }
                case INNERVATION: {
                    skillName = LocaleUtil.getLocaleString("skills.innervation.name");
                    lvl = levelInnervation;
                    xp = xpInnervation;
                    break;
                }
                case LOGGING: {
                    skillName = LocaleUtil.getLocaleString("skills.logging.name");
                    lvl = levelLogging;
                    xp = xpLogging;
                    break;
                }
                case RUNATION: {
                    skillName = LocaleUtil.getLocaleString("skills.runation.name");
                    lvl = levelRunation;
                    xp = xpRunation;
                }
            }
            if (!((Boolean)AoAConfig.CLIENT.showVanityLevels.get()).booleanValue() && lvl >= 100) {
                lvl = 100;
                hitXpCap = true;
            }
            if (lvl >= 1000) {
                hitXpCap = true;
            }
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, skillName, x + 31, y - 15, 1.5625f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.DROP_SHADOW);
            RenderSystem.scalef((float)1.25f, (float)1.25f, (float)1.25f);
            mc.field_71466_p.func_175063_a(LocaleUtil.getLocaleString("gui.aoa3.adventGui.stats.level", String.valueOf(lvl)), (float)x * 0.8f, (float)(y + 65) * 0.8f, NumberUtil.RGB(255, 255, 255));
            if (!hitXpCap) {
                mc.field_71466_p.func_175063_a(LocaleUtil.getLocaleString("gui.aoa3.adventGui.stats.xp", NumberUtil.floorAndAppendSuffix(xp, true), NumberUtil.floorAndAppendSuffix(PlayerUtil.getXpRequiredForNextLevel(lvl), true)), (float)x * 0.8f, (float)(y + 77) * 0.8f, NumberUtil.RGB(255, 255, 255));
            }
            RenderSystem.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        }
        RenderSystem.disableAlphaTest();
    }

    private void drawPlayerBox(int posX, int posY, int mouseX, int mouseY, int scale) {
        if (this.entityToRender == null) {
            this.setRenderEntity();
        }
        RenderSystem.scalef((float)1.6f, (float)1.6f, (float)1.6f);
        Minecraft mc = Minecraft.func_71410_x();
        String name = mc.field_71439_g.func_145748_c_().func_150254_d();
        RenderUtil.drawCenteredScaledString(mc.field_71466_p, name, (int)((float)posX * 0.625f), (int)((float)(posY - 170) * 0.625f), 1.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        RenderSystem.scalef((float)0.625f, (float)0.625f, (float)0.625f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrix = new MatrixStack();
        matrix.func_227861_a_(0.0, 0.0, 1000.0);
        matrix.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229179_b_.func_229187_a_(180.0f);
        matrix.func_227863_a_(quaternion);
        float yawOffset = this.entityToRender.field_70761_aq;
        float rotYaw = this.entityToRender.field_70177_z;
        float rotPitch = this.entityToRender.field_70125_A;
        float prevYawHead = this.entityToRender.field_70758_at;
        float rotYawHead = this.entityToRender.field_70759_as;
        this.entityToRender.field_70761_aq = 0.0f;
        this.entityToRender.field_70177_z = (float)Math.atan(((float)(AdventMainGui.scaledRootX + 264) / 2.2222223f - (float)mouseX) / 40.0f) * 40.0f;
        this.entityToRender.field_70125_A = -((float)Math.atan(((float)(AdventMainGui.scaledRootY + 465) / 2.2222223f - 50.0f - (float)mouseY) / 40.0f)) * 20.0f;
        this.entityToRender.field_70759_as = this.entityToRender.field_70177_z;
        this.entityToRender.field_70758_at = this.entityToRender.field_70177_z;
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.func_178633_a(false);
        IRenderTypeBuffer.Impl renderBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        renderManager.func_229084_a_((Entity)this.entityToRender, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (IRenderTypeBuffer)renderBuffer, 0xF000F0);
        renderBuffer.func_228461_a_();
        renderManager.func_178633_a(true);
        this.entityToRender.field_70761_aq = yawOffset;
        this.entityToRender.field_70177_z = rotYaw;
        this.entityToRender.field_70125_A = rotPitch;
        this.entityToRender.field_70758_at = prevYawHead;
        this.entityToRender.field_70759_as = rotYawHead;
        RenderSystem.popMatrix();
    }

    public static void setSkillData(Skills skill, float xp, int lvl, int opt) {
        switch (skill) {
            case ALCHEMY: {
                levelAlchemy = lvl;
                xpAlchemy = xp;
                percentCompleteAlchemy = PlayerUtil.getLevelProgressPercentage(levelAlchemy, xpAlchemy);
                break;
            }
            case ANIMA: {
                levelAnima = lvl;
                xpAnima = xp;
                percentCompleteAnima = PlayerUtil.getLevelProgressPercentage(levelAnima, xpAnima);
                break;
            }
            case AUGURY: {
                levelAugury = lvl;
                xpAugury = xp;
                percentCompleteAugury = PlayerUtil.getLevelProgressPercentage(levelAugury, xpAugury);
                break;
            }
            case BUTCHERY: {
                levelButchery = lvl;
                xpButchery = xp;
                percentCompleteButchery = PlayerUtil.getLevelProgressPercentage(levelButchery, xpButchery);
                break;
            }
            case CREATION: {
                levelCreation = lvl;
                xpCreation = xp;
                percentCompleteCreation = PlayerUtil.getLevelProgressPercentage(levelCreation, xpCreation);
                break;
            }
            case ENGINEERING: {
                levelEngineering = lvl;
                xpEngineering = xp;
                percentCompleteEngineering = PlayerUtil.getLevelProgressPercentage(levelEngineering, xpEngineering);
                break;
            }
            case EXPEDITION: {
                levelExpedition = lvl;
                xpExpedition = xp;
                optExpedition = opt;
                percentCompleteExpedition = PlayerUtil.getLevelProgressPercentage(levelExpedition, xpExpedition);
                break;
            }
            case EXTRACTION: {
                levelExtraction = lvl;
                xpExtraction = xp;
                percentCompleteExtraction = PlayerUtil.getLevelProgressPercentage(levelExtraction, xpExtraction);
                break;
            }
            case FORAGING: {
                levelForaging = lvl;
                xpForaging = xp;
                percentCompleteForaging = PlayerUtil.getLevelProgressPercentage(levelForaging, xpForaging);
                break;
            }
            case HAULING: {
                levelHauling = lvl;
                xpHauling = xp;
                percentCompleteHauling = PlayerUtil.getLevelProgressPercentage(levelHauling, xpHauling);
                break;
            }
            case HUNTER: {
                levelHunter = lvl;
                xpHunter = xp;
                percentCompleteHunter = PlayerUtil.getLevelProgressPercentage(levelHunter, xpHunter);
                break;
            }
            case INFUSION: {
                levelInfusion = lvl;
                xpInfusion = xp;
                percentCompleteInfusion = PlayerUtil.getLevelProgressPercentage(levelInfusion, xpInfusion);
                break;
            }
            case INNERVATION: {
                levelInnervation = lvl;
                xpInnervation = xp;
                percentCompleteInnervation = PlayerUtil.getLevelProgressPercentage(levelInnervation, xpInnervation);
                break;
            }
            case LOGGING: {
                levelLogging = lvl;
                xpLogging = xp;
                percentCompleteLogging = PlayerUtil.getLevelProgressPercentage(levelLogging, xpLogging);
                break;
            }
            case RUNATION: {
                levelRunation = lvl;
                xpRunation = xp;
                percentCompleteRunation = PlayerUtil.getLevelProgressPercentage(levelRunation, xpRunation);
            }
        }
    }

    public static void addXp(Skills skill, float additionalXp) {
        switch (skill) {
            case ALCHEMY: {
                percentCompleteAlchemy = PlayerUtil.getLevelProgressPercentage(levelAlchemy, xpAlchemy += additionalXp);
                break;
            }
            case ANIMA: {
                percentCompleteAnima = PlayerUtil.getLevelProgressPercentage(levelAnima, xpAnima += additionalXp);
                break;
            }
            case AUGURY: {
                percentCompleteAugury = PlayerUtil.getLevelProgressPercentage(levelAugury, xpAugury += additionalXp);
                break;
            }
            case BUTCHERY: {
                percentCompleteButchery = PlayerUtil.getLevelProgressPercentage(levelButchery, xpButchery += additionalXp);
                break;
            }
            case CREATION: {
                percentCompleteCreation = PlayerUtil.getLevelProgressPercentage(levelCreation, xpCreation += additionalXp);
                break;
            }
            case ENGINEERING: {
                percentCompleteEngineering = PlayerUtil.getLevelProgressPercentage(levelEngineering, xpEngineering += additionalXp);
                break;
            }
            case EXPEDITION: {
                percentCompleteExpedition = PlayerUtil.getLevelProgressPercentage(levelExpedition, xpExpedition += additionalXp);
                break;
            }
            case EXTRACTION: {
                percentCompleteExtraction = PlayerUtil.getLevelProgressPercentage(levelExtraction, xpExtraction += additionalXp);
                break;
            }
            case FORAGING: {
                percentCompleteForaging = PlayerUtil.getLevelProgressPercentage(levelForaging, xpForaging += additionalXp);
                break;
            }
            case HAULING: {
                percentCompleteHauling = PlayerUtil.getLevelProgressPercentage(levelHauling, xpHauling += additionalXp);
                break;
            }
            case HUNTER: {
                percentCompleteHunter = PlayerUtil.getLevelProgressPercentage(levelHunter, xpHunter += additionalXp);
                break;
            }
            case INFUSION: {
                percentCompleteInfusion = PlayerUtil.getLevelProgressPercentage(levelInfusion, xpInfusion += additionalXp);
                break;
            }
            case INNERVATION: {
                percentCompleteInnervation = PlayerUtil.getLevelProgressPercentage(levelInnervation, xpInnervation += additionalXp);
                break;
            }
            case LOGGING: {
                percentCompleteLogging = PlayerUtil.getLevelProgressPercentage(levelLogging, xpLogging += additionalXp);
                break;
            }
            case RUNATION: {
                percentCompleteRunation = PlayerUtil.getLevelProgressPercentage(levelRunation, xpRunation += additionalXp);
            }
        }
    }

    public static int getSkillLevel(Skills skill) {
        if (!((Boolean)AoAConfig.COMMON.skillsEnabled.get()).booleanValue()) {
            return 100;
        }
        switch (skill) {
            case ALCHEMY: {
                return levelAlchemy;
            }
            case ANIMA: {
                return levelAnima;
            }
            case AUGURY: {
                return levelAugury;
            }
            case BUTCHERY: {
                return levelButchery;
            }
            case CREATION: {
                return levelCreation;
            }
            case ENGINEERING: {
                return levelEngineering;
            }
            case EXPEDITION: {
                return levelExpedition;
            }
            case EXTRACTION: {
                return levelExtraction;
            }
            case FORAGING: {
                return levelForaging;
            }
            case HAULING: {
                return levelHauling;
            }
            case HUNTER: {
                return levelHunter;
            }
            case INFUSION: {
                return levelInfusion;
            }
            case INNERVATION: {
                return levelInnervation;
            }
            case LOGGING: {
                return levelLogging;
            }
            case RUNATION: {
                return levelRunation;
            }
        }
        return 1;
    }

    public static float getSkillXp(Skills skill) {
        switch (skill) {
            case ALCHEMY: {
                return xpAlchemy;
            }
            case ANIMA: {
                return xpAnima;
            }
            case AUGURY: {
                return xpAugury;
            }
            case BUTCHERY: {
                return xpButchery;
            }
            case CREATION: {
                return xpCreation;
            }
            case ENGINEERING: {
                return xpEngineering;
            }
            case EXPEDITION: {
                return xpExpedition;
            }
            case EXTRACTION: {
                return xpExtraction;
            }
            case FORAGING: {
                return xpForaging;
            }
            case HAULING: {
                return xpHauling;
            }
            case HUNTER: {
                return xpHunter;
            }
            case INFUSION: {
                return xpInfusion;
            }
            case INNERVATION: {
                return xpInnervation;
            }
            case LOGGING: {
                return xpLogging;
            }
            case RUNATION: {
                return xpRunation;
            }
        }
        return 0.0f;
    }

    public static int getPercentCompleteLevel(Skills skill) {
        switch (skill) {
            case ALCHEMY: {
                return percentCompleteAlchemy;
            }
            case ANIMA: {
                return percentCompleteAnima;
            }
            case AUGURY: {
                return percentCompleteAugury;
            }
            case BUTCHERY: {
                return percentCompleteButchery;
            }
            case CREATION: {
                return percentCompleteCreation;
            }
            case ENGINEERING: {
                return percentCompleteEngineering;
            }
            case EXPEDITION: {
                return percentCompleteExpedition;
            }
            case EXTRACTION: {
                return percentCompleteExtraction;
            }
            case FORAGING: {
                return percentCompleteForaging;
            }
            case HAULING: {
                return percentCompleteHauling;
            }
            case HUNTER: {
                return percentCompleteHunter;
            }
            case INFUSION: {
                return percentCompleteInfusion;
            }
            case INNERVATION: {
                return percentCompleteInnervation;
            }
            case LOGGING: {
                return percentCompleteLogging;
            }
            case RUNATION: {
                return percentCompleteRunation;
            }
        }
        return 0;
    }

    public static int getOptionalSkillData(Skills skill) {
        switch (skill) {
            case EXPEDITION: {
                return optExpedition;
            }
        }
        return 0;
    }

    public void onClose() {
        super.onClose();
        if (this.entityToRender != null && !(this.entityToRender instanceof PlayerEntity)) {
            this.entityToRender.func_70106_y();
        }
        this.entityToRender = null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int expeditionIconY = AdventMainGui.scaledTabRootY + 20 + (int)(Math.floor((float)Skills.EXPEDITION.id / 5.0f) * 112.0);
        int expeditionIconX = AdventMainGui.scaledTabRootX + 170 + 100 * (1 + Skills.EXPEDITION.id % 5);
        if (this.adjustedMouseX >= expeditionIconX && this.adjustedMouseX <= expeditionIconX + 62 && this.adjustedMouseY >= expeditionIconY && this.adjustedMouseY <= expeditionIconY + 62) {
            AoAPackets.messageServer(new ExpeditionTogglePacket());
            return true;
        }
        return false;
    }

    private void setRenderEntity() {
        if (this.entityToRender == null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (optExpedition >= 4) {
                switch (RandomUtil.randomNumberUpTo(29)) {
                    case 0: {
                        this.entityToRender = new ArcwormEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ARCWORM.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 1: {
                        this.entityToRender = new ChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 2: {
                        this.entityToRender = new DesertChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.DESERT_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 3: {
                        this.entityToRender = new HillChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.HILL_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 4: {
                        this.entityToRender = new OcculentEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.OCCULENT.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 5: {
                        this.entityToRender = new SeaChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SEA_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 6: {
                        this.entityToRender = new SnowChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SNOW_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 7: {
                        this.entityToRender = new SwampChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SWAMP_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 8: {
                        this.entityToRender = new VoidChargerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.VOID_CHARGER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 9: {
                        this.entityToRender = new FacelessRunnerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.FACELESS_RUNNER.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 10: {
                        this.entityToRender = new GruntEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.GRUNT.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 11: {
                        this.entityToRender = new CyclopsEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CYCLOPS.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 12: {
                        this.entityToRender = new BruteEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BRUTE.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 13: {
                        this.entityToRender = new KrankyEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.KRANKY.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 14: {
                        this.entityToRender = new GingerbreadManEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.GINGERBREAD_MAN.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 15: {
                        this.entityToRender = new ShadeEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SHADE.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 16: {
                        this.entityToRender = new BoboEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BOBO.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 17: {
                        this.entityToRender = new ChockoEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.CHOCKO.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 18: {
                        this.entityToRender = new StitchesEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STITCHES.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 19: {
                        this.entityToRender = new BugeyeEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BUGEYE.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 20: {
                        this.entityToRender = new SeaTrollEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SEA_TROLL.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 21: {
                        this.entityToRender = new ShyreTrollEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SHYRE_TROLL.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 22: {
                        this.entityToRender = new EliteSkelePigEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELITE_SKELE_PIG.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 23: {
                        this.entityToRender = new SpearmintSnailEntity((EntityType<? extends AnimalEntity>)((EntityType)AoAEntities.Animals.SPEARMINT_SNAIL.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 24: {
                        this.entityToRender = new ShadowEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SHADOW.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 25: {
                        this.entityToRender = new SeaSkeletonEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SEA_SKELETON.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 26: {
                        this.entityToRender = new AlarmoEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ALARMO.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 27: {
                        this.entityToRender = new AncientGolemEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ANCIENT_GOLEM.get()), (World)mc.field_71441_e);
                        break;
                    }
                    case 28: {
                        this.entityToRender = new StickyEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STICKY.get()), (World)mc.field_71441_e);
                    }
                }
            } else {
                this.entityToRender = mc.field_71439_g;
            }
        }
    }
}

