/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.client.Keybinds;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabGuides;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabHelp;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.WebUtil;

@OnlyIn(value=Dist.CLIENT)
public class AdventMainGui
extends Screen
implements IProgressMeter {
    private static final ResourceLocation titleResource = HolidayUtil.getCurrentHoliday() == HolidayUtil.Holiday.APRIL_FOOLS ? new ResourceLocation("aoa3", "textures/gui/maingui/aoa_title_alt.png") : new ResourceLocation("aoa3", "textures/gui/maingui/aoa_title.png");
    public static Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
    protected static final ArrayList<AdventGuiTextures> textures = new ArrayList();
    protected static int currentTextureIndex = 0;
    private static AdventMainGui instance;
    private static ADVENT_WINDOW_TAB selectedTab;
    @Nullable
    private static Screen tabScreen;
    protected PlayerEntity player;
    protected static final int guiWidth = 976;
    protected static final int guiHeight = 480;
    protected static final float scale = 0.45f;
    protected static final float scaleInverse = 2.2222223f;
    protected static int scaledRootX;
    protected static int scaledRootY;
    protected static int scaledTabRootX;
    protected static int scaledTabRootY;
    private static int updateMessageTicker;

    public AdventMainGui(PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.aoa3.adventGui.title", new Object[0]));
        instance = this;
        if (this.player == null || this.player.func_130014_f_() == null || this.player.func_130014_f_() != player.func_130014_f_()) {
            tabScreen = null;
        }
        this.player = player;
        currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (textures.isEmpty()) {
            AdventMainGui.prepTextures();
        }
    }

    public static boolean isBlockingKeys() {
        if (tabScreen instanceof AdventGuiTabBestiary) {
            TextFieldWidget bestiarySearchField = ((AdventGuiTabBestiary)AdventMainGui.tabScreen).searchField;
            return bestiarySearchField != null && bestiarySearchField.isFocused();
        }
        return false;
    }

    protected void init() {
        this.addButton(new AdventMainGuiTabButton(11, 129, LocaleUtil.getLocaleString("gui.aoa3.adventGui.stats"), ADVENT_WINDOW_TAB.PLAYER));
        this.addButton(new AdventMainGuiTabButton(11, 199, LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary"), ADVENT_WINDOW_TAB.BESTIARY));
        this.addButton(new AdventMainGuiTabButton(11, 269, LocaleUtil.getLocaleString("gui.aoa3.adventGui.guides"), ADVENT_WINDOW_TAB.GUIDES));
        this.addButton(new AdventMainGuiTabButton(11, 339, LocaleUtil.getLocaleString("gui.aoa3.adventGui.help"), ADVENT_WINDOW_TAB.HELP));
        this.correctGuiPositions();
        this.initTabScreen();
        for (int i = 0; i < textures.size(); ++i) {
            if (!textures.get(i).name.equalsIgnoreCase((String)AoAConfig.CLIENT.adventGuiTheme.get())) continue;
            currentTextureIndex = i;
            break;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        AdventGuiTextures currentTextures = textures.get(currentTextureIndex);
        this.getMinecraft().func_110434_K().func_110577_a(currentTextures.backgroundTexture);
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.scalef((float)0.45f, (float)0.45f, (float)0.45f);
        RenderUtil.renderCustomSizedTexture(scaledRootX, scaledRootY, 24.0f, 16.0f, 976, 480, 1024.0f, 512.0f);
        this.getMinecraft().func_110434_K().func_110577_a(titleResource);
        RenderUtil.renderCustomSizedTexture(scaledRootX - 24 + 68, scaledRootY - 16 + 21, 0.0f, 0.0f, 892, 112, 892.0f, 112.0f);
        RenderSystem.scalef((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.scalef((float)0.45f, (float)0.45f, (float)0.45f);
        if (currentTextures.overlayTexture != null) {
            this.getMinecraft().func_110434_K().func_110577_a(currentTextures.overlayTexture);
            RenderSystem.enableBlend();
            RenderUtil.renderCustomSizedTexture(scaledRootX - 24, scaledRootY - 16, 0.0f, 0.0f, 1024, 512, 1024.0f, 512.0f);
            RenderSystem.disableBlend();
        }
        RenderSystem.scalef((float)1.25f, (float)1.25f, (float)1.25f);
        this.font.func_175063_a("v3.4.9", (float)(scaledRootX + 175) / 1.25f, (float)(scaledRootY + 85) / 1.25f, NumberUtil.RGB(255, 223, 0));
        if (WebUtil.isUpdateAvailable()) {
            if (--updateMessageTicker <= -30) {
                updateMessageTicker = 90;
            }
            if (updateMessageTicker > 0) {
                String msg = LocaleUtil.getLocaleString("gui.aoa3.adventGui.update", WebUtil.getLatestVersion());
                this.font.func_175063_a(msg, (float)((int)((float)(scaledRootX + 925 - this.font.func_78256_a(msg)) / 1.25f)), (float)((int)((float)(scaledRootY + 105) / 1.25f)), NumberUtil.RGB(229, 0, 0));
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        if (tabScreen != null) {
            tabScreen.render(mouseX, mouseY, partialTicks);
        }
        RenderSystem.scalef((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void func_193026_g() {
        if (tabScreen instanceof IProgressMeter) {
            ((IProgressMeter)tabScreen).func_193026_g();
        }
    }

    private static void prepTextures() {
        textures.add(new AdventGuiTextures("Default", null, null, null));
        textures.add(new AdventGuiTextures("Jungle", new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/overlay.png")));
        textures.add(new AdventGuiTextures("Ancient Ruins", new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/ancientruins/overlay.png")));
        textures.add(new AdventGuiTextures("Hell", new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/overlay.png")));
        textures.add(new AdventGuiTextures("Crystals", new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/overlay.png")));
        textures.add(new AdventGuiTextures("Transparent", new ResourceLocation("aoa3", "textures/gui/maingui/themes/transparent/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/transparent/tab_buttons.png"), null));
        textures.add(new AdventGuiTextures("Dark", new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/tab_buttons.png"), null));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (tabScreen != null) {
            return tabScreen.mouseScrolled(mouseX, mouseY, scrollAmount);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean used = false;
        if (tabScreen != null) {
            used = tabScreen.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button) || used;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean used = false;
        if (tabScreen != null) {
            used = tabScreen.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button) || used;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!AdventMainGui.isBlockingKeys() && keyCode == Keybinds.keyAdventGui.getKey().func_197937_c()) {
            this.getMinecraft().func_147108_a(null);
            return true;
        }
        boolean used = false;
        if (tabScreen != null) {
            used = tabScreen.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers) || used;
    }

    public boolean charTyped(char character, int arg) {
        if (tabScreen != null) {
            return tabScreen.charTyped(character, arg);
        }
        return super.charTyped(character, arg);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (!super.func_223281_a_(keyCode, scanCode, modifiers)) {
            if (tabScreen != null) {
                return tabScreen.func_223281_a_(keyCode, scanCode, modifiers);
            }
            return false;
        }
        return true;
    }

    private void initTabScreen() {
        Minecraft mc = this.getMinecraft();
        int tabWidth = (int)((float)(this.width + 182) * 0.45f);
        int tabHeight = (int)((float)(this.height + 118) * 0.45f);
        if (tabScreen != null) {
            tabScreen.init(mc, tabWidth, tabHeight);
        } else {
            switch (selectedTab) {
                case PLAYER: {
                    tabScreen = new AdventGuiTabPlayer();
                    tabScreen.resize(mc, tabWidth, tabHeight);
                    break;
                }
                case HELP: {
                    tabScreen = new AdventGuiTabHelp();
                    tabScreen.resize(mc, tabWidth, tabHeight);
                    break;
                }
                case BESTIARY: {
                    tabScreen = new AdventGuiTabBestiary();
                    tabScreen.resize(mc, tabWidth, tabHeight);
                    break;
                }
                case GUIDES: {
                    tabScreen = new AdventGuiTabGuides();
                    tabScreen.resize(mc, tabWidth, tabHeight);
                    break;
                }
                default: {
                    tabScreen = null;
                }
            }
        }
    }

    private ResourceLocation getTitleBarTexture() {
        return titleResource;
    }

    public boolean isPauseScreen() {
        return (Boolean)AoAConfig.CLIENT.adventGuiPausesGame.get();
    }

    private void correctGuiPositions() {
        MainWindow window = this.getMinecraft().func_228018_at_();
        scaledRootX = (int)(Math.round((double)window.func_198107_o() / 2.0 / (double)0.45f) - Math.round(488.0));
        scaledRootY = (int)(Math.round((double)window.func_198087_p() / 2.0 / (double)0.45f) - Math.round(240.0));
        scaledTabRootX = scaledRootX + 201;
        scaledTabRootY = scaledRootY + 129;
    }

    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.correctGuiPositions();
        if (tabScreen != null) {
            tabScreen.resize(mc, (int)((float)(width + 182) * 0.45f), (int)((float)(height + 118) * 0.45f));
        }
    }

    public void onClose() {
        super.onClose();
        if (tabScreen != null) {
            tabScreen.onClose();
        }
    }

    public static void addTheme(String name, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonsTexture, @Nullable ResourceLocation overlayTexture) {
        textures.add(new AdventGuiTextures(name, backgroundTexture, menuButtonsTexture, overlayTexture));
    }

    protected static void changeTheme() {
        AoAConfig.CLIENT.changeAdventGuiTheme(textures.get(currentTextureIndex).name);
    }

    static {
        selectedTab = ADVENT_WINDOW_TAB.PLAYER;
        updateMessageTicker = 0;
    }

    protected static class AdventGuiTextures {
        private final String name;
        @Nullable
        protected final ResourceLocation overlayTexture;
        protected final ResourceLocation backgroundTexture;
        protected final ResourceLocation menuButtonTexture;

        private AdventGuiTextures(String name, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
            this.name = name;
            this.backgroundTexture = backgroundTexture == null ? new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/background.png") : backgroundTexture;
            this.menuButtonTexture = menuButtonTexture == null ? new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/tab_buttons.png") : menuButtonTexture;
            this.overlayTexture = overlayTexture;
        }
    }

    private static class AdventMainGuiTabButton
    extends Widget {
        private static final int buttonWidth = 180;
        private static final int buttonHeight = 60;
        private final ADVENT_WINDOW_TAB tabID;

        private AdventMainGuiTabButton(int x, int y, String buttonText, ADVENT_WINDOW_TAB tab) {
            super(x, y, 180, 60, buttonText);
            this.tabID = tab;
        }

        public void renderButton(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(AdventMainGui.textures.get((int)AdventMainGui.currentTextureIndex).menuButtonTexture);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.scalef((float)0.45f, (float)0.45f, (float)0.45f);
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.x, this.y);
                boolean textureX = false;
                int textureY = 60 * (this.tabID == selectedTab ? 0 : (this.getYImage(this.isHovered) == 2 ? 1 : 2));
                RenderUtil.renderScaledCustomSizedTexture(scaledRootX + this.x, scaledRootY + this.y, (float)textureX, textureY, 180.0f, 60.0f, 180.0, 60.0, 180.0f, 180.0f);
                int stringColour = NumberUtil.RGB(239, 137, 119);
                if (this.getFGColor() != 0) {
                    stringColour = this.getFGColor();
                } else if (!this.active) {
                    stringColour = 0xA0A0A0;
                } else if (this.isHovered || this.tabID == selectedTab) {
                    stringColour = NumberUtil.RGB(247, 239, 0);
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.getMessage(), scaledRootX + this.x + 90, scaledRootY + this.y + 25, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
                RenderSystem.scalef((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
            }
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return this.active && this.isHovered && selectedTab != this.tabID;
        }

        public void onClick(double mouseX, double mouseY) {
            selectedTab = this.tabID;
            tabScreen = null;
            instance.initTabScreen();
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(scaledRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(scaledRootX + buttonX + 180) * 0.45f) && mouseY >= (int)((float)(scaledRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(scaledRootY + buttonY + 60) * 0.45f);
        }
    }

    protected static enum ADVENT_WINDOW_TAB {
        PLAYER,
        BESTIARY,
        GUIDES,
        HELP;

    }
}

