/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.container.CorruptedTravellerContainer;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;

public class CorruptedTravellerScreen
extends ContainerScreen<CorruptedTravellerContainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("aoa3", "textures/gui/containers/corrupted_traveller.png");
    private static final ArrayList<Item> validFoods = new ArrayList();
    private long nextFoodTick = 0L;
    private Item currentGhostlyFood = Items.field_151034_e;
    private final Minecraft mc = Minecraft.func_71410_x();

    public CorruptedTravellerScreen(CorruptedTravellerContainer container, PlayerInventory inv, ITextComponent guiTitle) {
        super((Container)container, inv, guiTitle);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(guiTexture);
        int centerX = (this.width - this.field_146999_f) / 2;
        int centerY = (this.height - this.field_147000_g) / 2;
        RenderUtil.renderCustomSizedTexture(centerX, centerY, 0.0f, 0.0f, this.field_146999_f, this.field_147000_g, 256.0f, 256.0f);
        this.renderGhostlyFood(centerX, centerY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int titleWidth = 4 + this.mc.field_71466_p.func_78256_a(this.title.func_150254_d());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(guiTexture);
        RenderUtil.renderCustomSizedTexture(28, 4, 176.0f, 0.0f, 1, 12, 256.0f, 256.0f);
        for (int i = 0; i < titleWidth - 2; ++i) {
            RenderUtil.renderCustomSizedTexture(29 + i, 4, 177.0f, 0.0f, 1, 12, 256.0f, 256.0f);
        }
        RenderUtil.renderCustomSizedTexture(28 + titleWidth - 2, 4, 178.0f, 0.0f, 1, 12, 256.0f, 256.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71466_p.func_211126_b(this.title.func_150254_d(), 30.0f, 6.0f, NumberUtil.RGB(255, 255, 255));
    }

    private void renderGhostlyFood(int centerX, int centerY) {
        Slot slot = ((CorruptedTravellerContainer)this.field_147002_h).func_75139_a(0);
        if (!slot.func_75216_d()) {
            boolean diffuseLighting;
            ItemStack stack = new ItemStack((IItemProvider)this.getGhostlyFood());
            IBakedModel model = this.mc.func_175599_af().func_184393_a(stack, null, null);
            RenderSystem.pushMatrix();
            this.mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            this.mc.field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.translatef((float)(slot.field_75223_e + centerX), (float)(slot.field_75221_f + centerY), (float)100.0f);
            RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
            RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
            MatrixStack matrixstack = new MatrixStack();
            IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            boolean bl = diffuseLighting = !model.func_230044_c_();
            if (diffuseLighting) {
                RenderHelper.func_227783_c_();
            }
            this.mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)renderTypeBuffer, 100, OverlayTexture.field_229196_a_, model);
            renderTypeBuffer.func_228461_a_();
            RenderSystem.enableDepthTest();
            if (diffuseLighting) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            RenderSystem.popMatrix();
        }
    }

    private void compileFoodList() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!item.func_219971_r()) continue;
            validFoods.add(item);
        }
    }

    @Nonnull
    private Item getGhostlyFood() {
        long worldTick;
        if (validFoods.isEmpty()) {
            this.compileFoodList();
        }
        if ((worldTick = this.mc.field_71441_e.func_82737_E()) >= this.nextFoodTick) {
            this.currentGhostlyFood = validFoods.get(RandomUtil.randomNumberUpTo(validFoods.size()));
            this.nextFoodTick = worldTick + 20L;
        }
        return this.currentGhostlyFood;
    }
}

