/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.tslat.aoa3.common.container.FrameBenchContainer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GuiDataPacket;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;

public class FrameBenchScreen
extends ContainerScreen<FrameBenchContainer> {
    private static final ResourceLocation textures = new ResourceLocation("aoa3", "textures/gui/containers/frame_bench.png");
    private static String currentSelection = "helmet";

    public FrameBenchScreen(FrameBenchContainer container, PlayerInventory inv, ITextComponent guiTitle) {
        super((Container)container, inv, guiTitle);
        currentSelection = "helmet";
    }

    public void init() {
        super.init();
        this.addButton(new FrameSelectButton(this.field_147003_i + 45, this.field_147009_r + 33, "Helmet", "helmet", (Item)AoAItems.HELMET_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 65, this.field_147009_r + 33, "Chestplate", "chestplate", (Item)AoAItems.CHESTPLATE_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 85, this.field_147009_r + 33, "Leggings", "leggings", (Item)AoAItems.LEGGINGS_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 105, this.field_147009_r + 33, "Boots", "boots", (Item)AoAItems.BOOTS_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 55, this.field_147009_r + 13, "Crossbow", "crossbow", (Item)AoAItems.CROSSBOW_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 75, this.field_147009_r + 13, "Blaster", "blaster", (Item)AoAItems.BLASTER_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 95, this.field_147009_r + 13, "Cannon", "cannon", (Item)AoAItems.CANNON_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 55, this.field_147009_r + 53, "Gun", "gun", (Item)AoAItems.GUN_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 75, this.field_147009_r + 53, "Shotgun", "shotgun", (Item)AoAItems.SHOTGUN_FRAME.get()));
        this.addButton(new FrameSelectButton(this.field_147003_i + 95, this.field_147009_r + 53, "Sniper", "sniper", (Item)AoAItems.SNIPER_FRAME.get()));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (Widget button : this.buttons) {
            if (!button.isHovered()) continue;
            button.renderToolTip(mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textures);
        RenderUtil.renderCustomSizedTexture(this.field_147003_i, this.field_147009_r, 0.0f, 0.0f, 175, 165, 256.0f, 256.0f);
    }

    private static class FrameSelectButton
    extends Widget {
        private static final int buttonWidth = 18;
        private static final int buttonHeight = 18;
        private final String selectionValue;
        private final Item frame;

        private FrameSelectButton(int x, int y, String buttonText, String selectionValue, Item frame) {
            super(x, y, 18, 18, buttonText);
            this.selectionValue = selectionValue;
            this.frame = frame;
        }

        public void renderButton(int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(textures);
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.x, this.y);
            int textureX = 176;
            int textureY = 21 + 18 * (this.selectionValue.equals(currentSelection) ? 0 : (this.getYImage(this.isHovered) == 2 ? 2 : 1));
            RenderUtil.renderCustomSizedTexture(this.x, this.y, textureX, textureY, 18, 18, 256.0f, 256.0f);
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
            mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)this.frame), this.x + 1, this.y + 1);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.popMatrix();
        }

        public void renderToolTip(int mouseX, int mouseY) {
            ItemStack stack = new ItemStack((IItemProvider)this.frame);
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawHoveringText((ItemStack)stack, Collections.singletonList(LocaleUtil.getItemName((IItemProvider)this.frame)), (int)mouseX, (int)mouseY, (int)window.func_198107_o(), (int)window.func_198087_p(), (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= buttonX && mouseX <= buttonX + 18 && mouseY >= buttonY && mouseY <= buttonY + 18;
        }

        protected boolean clicked(double p_clicked_1_, double p_clicked_3_) {
            return this.active && this.isHovered && !this.selectionValue.equals(currentSelection);
        }

        public void onClick(double p_onClick_1_, double p_onClick_3_) {
            currentSelection = this.selectionValue;
            AoAPackets.messageServer(new GuiDataPacket(GuiDataPacket.Type.FRAME_BENCH_SELECTION, currentSelection));
            ((FrameBenchContainer)((FrameBenchScreen)Minecraft.func_71410_x().field_71462_r).func_212873_a_()).changeSelection(currentSelection);
        }
    }
}

