/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.util.RenderUtil;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class BossBarRenderer {
    private static final HashMap<String, ResourceLocation> textureCache = new HashMap();

    @SubscribeEvent
    public static void renderBossBar(RenderGameOverlayEvent.BossInfo ev) {
        if (!ev.isCanceled()) {
            ITextComponent nameComponent = ev.getBossInfo().func_186744_e();
            if (nameComponent.func_150253_a().isEmpty() || !(nameComponent instanceof TranslationTextComponent)) {
                return;
            }
            String name = ((ITextComponent)nameComponent.func_150253_a().get(0)).func_150254_d();
            String id = ((TranslationTextComponent)nameComponent).func_150268_i();
            if (!id.startsWith("entity.aoa3.")) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow mainWindow = mc.func_228018_at_();
            ResourceLocation texture = BossBarRenderer.getTexture(id.substring(12));
            int textureWidth = 196;
            int xPos = mainWindow.func_198107_o() / 2 - 100;
            int percentPixels = (int)Math.ceil(ev.getBossInfo().func_186738_f() * (float)textureWidth);
            int stringWidth = mc.field_71466_p.func_78256_a(name);
            int x = mainWindow.func_198107_o() / 2 - stringWidth / 2;
            RenderSystem.pushMatrix();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(texture);
            if (percentPixels < textureWidth) {
                RenderUtil.renderCustomSizedTexture(xPos, ev.getY(), 0.0f, 12.0f, 200, 12, 200.0f, 36.0f);
            }
            if (percentPixels > 0) {
                RenderUtil.renderCustomSizedTexture(xPos + 2, ev.getY(), 2.0f, 0.0f, percentPixels, 12, 200.0f, 36.0f);
            }
            RenderUtil.renderCustomSizedTexture(xPos, ev.getY(), 0.0f, 24.0f, 200, 12, 200.0f, 36.0f);
            mc.field_71466_p.func_175063_a(name, (float)x, (float)(ev.getY() - 9), 0xFFFFFF);
            RenderSystem.enableDepthTest();
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
            ev.setIncrement(ev.getIncrement() + 5);
            ev.setCanceled(true);
        }
    }

    private static ResourceLocation getTexture(String id) {
        if (textureCache.containsKey(id)) {
            return textureCache.get(id);
        }
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/bossbars/" + id + ".png");
        textureCache.put(id, texture);
        return texture;
    }
}

