/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.client.Keybinds;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ResourcesRenderer {
    private static final ResourceLocation resources = new ResourceLocation("aoa3:textures/gui/maingui/resources.png");
    public static boolean revengeActive = false;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderTick(TickEvent.RenderTickEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ev.phase == TickEvent.Phase.END && mc.field_71462_r == null && !mc.field_71474_y.field_74319_N && mc.field_71439_g != null && !mc.field_71439_g.func_175149_v() && ((Boolean)AoAConfig.COMMON.resourcesEnabled.get()).booleanValue()) {
            RenderSystem.pushMatrix();
            RenderSystem.disableDepthTest();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            int scaledWidth = mc.func_228018_at_().func_198107_o();
            int scaledHeight = mc.func_228018_at_().func_198087_p();
            if (((Boolean)AoAConfig.CLIENT.hudResourcesHorizontal.get()).booleanValue()) {
                switch ((HudResourcesPosition)((Object)AoAConfig.CLIENT.hudResourcesPosition.get())) {
                    case Bottom_Right: {
                        ResourcesRenderer.renderHorizontalResources(mc, (int)((float)(scaledWidth - 150) / 0.5f), (int)((float)(scaledHeight - 25) / 0.5f));
                        break;
                    }
                    case Bottom_Left: {
                        ResourcesRenderer.renderHorizontalResources(mc, 0, (int)((float)(scaledHeight - 25) / 0.5f));
                        break;
                    }
                    case Top_Left: {
                        ResourcesRenderer.renderHorizontalResources(mc, 0, 0);
                        break;
                    }
                    default: {
                        ResourcesRenderer.renderHorizontalResources(mc, (int)((float)(scaledWidth - 150) / 0.5f), ResourcesRenderer.getPotionGuiRenderOffset(mc));
                        break;
                    }
                }
            } else {
                switch ((HudResourcesPosition)((Object)AoAConfig.CLIENT.hudResourcesPosition.get())) {
                    case Bottom_Right: {
                        ResourcesRenderer.renderVerticalResources(mc, (int)((float)(scaledWidth - 25) / 0.5f), (int)((float)(scaledHeight - 150) / 0.5f));
                        break;
                    }
                    case Bottom_Left: {
                        ResourcesRenderer.renderVerticalResources(mc, 0, (int)((float)(scaledHeight - 150) / 0.5f));
                        break;
                    }
                    case Top_Left: {
                        ResourcesRenderer.renderVerticalResources(mc, 0, 0);
                        break;
                    }
                    default: {
                        ResourcesRenderer.renderVerticalResources(mc, (int)((float)(scaledWidth - 25) / 0.5f), ResourcesRenderer.getPotionGuiRenderOffset(mc));
                    }
                }
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
        }
    }

    private static int getPotionGuiRenderOffset(Minecraft mc) {
        if (mc.field_71439_g.func_70651_bq().isEmpty() || ((Boolean)AoAConfig.CLIENT.disableHudPotionOffset.get()).booleanValue()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (EffectInstance effect : mc.field_71439_g.func_70651_bq()) {
            if (effect.func_76459_b() <= 0 || !effect.func_188419_a().shouldRenderHUD(effect) || !effect.func_188418_e()) continue;
            if (!effect.func_188419_a().func_188408_i()) {
                effectRenderYOffset = 100;
                break;
            }
            effectRenderYOffset = 50;
        }
        return effectRenderYOffset;
    }

    private static void renderHorizontalResources(Minecraft mc, int rootX, int rootY) {
        if (Keybinds.statusResourceGui) {
            mc.func_110434_K().func_110577_a(resources);
            if (revengeActive) {
                RenderUtil.renderScaledCustomSizedTexture(rootX, rootY, 100.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            }
            float percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceRage / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 50, rootY, 0.0f, 190.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 50, rootY, AdventGuiTabPlayer.resourceRage >= 180.0f ? 50.0f : 0.0f, 240.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeSelyan / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY, 0.0f, 490.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY, 0.0f, 540.0f, percentComplete, 15.0f, percentComplete, 15.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeLuxon / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 15, 0.0f, 505.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 15, 0.0f, 555.0f, percentComplete, 10.0f, percentComplete, 10.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeErebon / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 25, 0.0f, 515.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 25, 0.0f, 565.0f, percentComplete, 10.0f, percentComplete, 10.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributePluton / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 35, 0.0f, 525.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 100, rootY + 35, 0.0f, 575.0f, percentComplete, 15.0f, percentComplete, 15.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceEnergy / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 150, rootY, 0.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 150, rootY, 0.0f, 140.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceCreation / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 200, rootY, 0.0f, 290.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 200, rootY, 0.0f, 340.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceSoul / 200.0f * 50.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 250, rootY, 0.0f, 390.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX + 250, rootY, 0.0f, 440.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceRage), rootX + 76, rootY + 28, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceEnergy), rootX + 176, rootY + 28, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceCreation), rootX + 226, rootY + 28, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceSoul), rootX + 276, rootY + 28, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        } else if (Keybinds.statusResourceGuiMessage && Keybinds.keyResourceGui.getKey().func_197937_c() != -1) {
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("gui.aoa3.resources.showtip", Keybinds.keyResourceGui.func_197978_k()), rootX + 150, rootY + 2, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        }
    }

    private static void renderVerticalResources(Minecraft mc, int rootX, int rootY) {
        if (Keybinds.statusResourceGui) {
            mc.func_110434_K().func_110577_a(resources);
            if (revengeActive) {
                RenderUtil.renderScaledCustomSizedTexture(rootX, rootY, 0.0f, 500.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            }
            float percentComplete = AdventGuiTabPlayer.resourceRage / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 50, 0.0f, 190.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 50, AdventGuiTabPlayer.resourceRage >= 180.0f ? 50.0f : 0.0f, 240.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeSelyan / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 100, 0.0f, 490.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 100, 0.0f, 540.0f, percentComplete * 50.0f, 15.0f, percentComplete * 50.0f, 15.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeLuxon / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 115, 0.0f, 505.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 115, 0.0f, 555.0f, percentComplete * 50.0f, 10.0f, percentComplete * 50.0f, 10.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeErebon / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 125, 0.0f, 515.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 125, 0.0f, 565.0f, percentComplete * 50.0f, 10.0f, percentComplete * 50.0f, 10.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributePluton / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 135, 0.0f, 525.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 135, 0.0f, 575.0f, percentComplete * 50.0f, 15.0f, percentComplete * 50.0f, 15.0, 400.0f, 590.0f);
            percentComplete = AdventGuiTabPlayer.resourceEnergy / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 150, 0.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 150, 0.0f, 140.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            percentComplete = AdventGuiTabPlayer.resourceEnergy / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 200, 0.0f, 290.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 200, 0.0f, 340.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            percentComplete = AdventGuiTabPlayer.resourceEnergy / 200.0f;
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 250, 0.0f, 390.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.renderScaledCustomSizedTexture(rootX, rootY + 250, 0.0f, 440.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceRage), rootX + 26, rootY + 76, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceEnergy), rootX + 26, rootY + 176, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceCreation), rootX + 26, rootY + 226, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceSoul), rootX + 26, rootY + 276, 2.0f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        } else if (Keybinds.statusResourceGuiMessage && Keybinds.keyResourceGui.getKey().func_197937_c() != -1) {
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("gui.aoa3.resources.showtip", Keybinds.keyResourceGui.func_197978_k()), rootX + 150, rootY + 2, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        }
    }

    public static enum HudResourcesPosition {
        Top_Right,
        Top_Left,
        Bottom_Right,
        Bottom_Left;

    }
}

