/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.client.Keybinds;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.client.gui.hud.ResourcesRenderer;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.constant.Skills;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class SkillsRenderer {
    private static final ResourceLocation skills = new ResourceLocation("aoa3:textures/gui/maingui/skills.png");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderTick(TickEvent.RenderTickEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && !mc.field_71474_y.field_74319_N && mc.field_71439_g != null && !mc.field_71439_g.func_175149_v() && ((Boolean)AoAConfig.COMMON.skillsEnabled.get()).booleanValue()) {
            RenderSystem.pushMatrix();
            RenderSystem.disableDepthTest();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            int scaledWidth = mc.func_228018_at_().func_198107_o();
            int renderOffsetY = 1 + SkillsRenderer.getPotionGuiRenderOffset(mc);
            int renderOffsetX = (int)((float)(scaledWidth - 200) / 0.5f);
            if (AoAConfig.CLIENT.hudResourcesPosition.get() == ResourcesRenderer.HudResourcesPosition.Top_Right) {
                if (!((Boolean)AoAConfig.CLIENT.hudResourcesHorizontal.get()).booleanValue()) {
                    if (Keybinds.statusResourceGui) {
                        renderOffsetX -= 50;
                    }
                } else if (Keybinds.statusResourceGui) {
                    renderOffsetY += 50;
                } else if (Keybinds.statusResourceGuiMessage) {
                    renderOffsetY += 15;
                }
            }
            SkillsRenderer.renderSkills(mc, renderOffsetX, renderOffsetY);
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
        }
    }

    private static void renderSkills(Minecraft mc, int rootX, int rootY) {
        if (Keybinds.statusSkillGui) {
            for (Skills skill : Skills.values()) {
                mc.func_110434_K().func_110577_a(skills);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int y = rootY + (int)Math.floor((float)skill.id / 8.0f) * 50;
                int x = rootX + 50 * (skill.id % 8);
                int progressBarPercent = AdventGuiTabPlayer.getPercentCompleteLevel(skill);
                int uvX = 0;
                int uvY = 0;
                int optionalUvX = -1;
                int optionalUvY = -1;
                int level = AdventGuiTabPlayer.getSkillLevel(skill);
                block0 : switch (skill) {
                    case ALCHEMY: {
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case ANIMA: {
                        uvX = 50;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case AUGURY: {
                        uvX = 100;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case BUTCHERY: {
                        uvX = 150;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case CREATION: {
                        uvX = 200;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case ENGINEERING: {
                        uvX = 250;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case EXPEDITION: {
                        uvX = 300;
                        uvY = level >= 100 ? 50 : 0;
                        switch (AdventGuiTabPlayer.getOptionalSkillData(Skills.EXPEDITION) % 4) {
                            case 1: {
                                optionalUvX = 300;
                                optionalUvY = 100;
                                break block0;
                            }
                            case 2: {
                                optionalUvX = 324;
                                optionalUvY = 100;
                                break block0;
                            }
                            case 3: {
                                optionalUvX = 348;
                                optionalUvY = 100;
                                break block0;
                            }
                        }
                        break;
                    }
                    case EXTRACTION: {
                        uvX = 350;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case FORAGING: {
                        uvX = 400;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case HAULING: {
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case HUNTER: {
                        uvX = 50;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case INFUSION: {
                        uvX = 100;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case INNERVATION: {
                        uvX = 150;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case LOGGING: {
                        uvX = 200;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case RUNATION: {
                        uvX = 250;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                    }
                }
                RenderUtil.renderScaledCustomSizedTexture(x, y, uvX, uvY, 50.0f, 50.0f, 50.0, 50.0, 450.0f, 240.0f);
                RenderUtil.renderScaledCustomSizedTexture(x, y + 37, 0.0f, 200.0f, 100.0f, 20.0f, 50.0, 13.0, 450.0f, 240.0f);
                RenderUtil.renderScaledCustomSizedTexture(x, y + 37, 0.0f, 220.0f, progressBarPercent, 20.0f, (float)progressBarPercent / 100.0f * 50.0f, 13.0, 450.0f, 240.0f);
                if (optionalUvX >= 0) {
                    RenderUtil.renderScaledCustomSizedTexture(x, y, optionalUvX, optionalUvY, 24.0f, 24.0f, 24.0, 24.0, 450.0f, 240.0f);
                }
                RenderUtil.drawScaledString(mc.field_71466_p, String.valueOf(level), x + 45 - (int)((float)mc.field_71466_p.func_78256_a(String.valueOf(level)) * 1.5f), y, 1.5f, level < 100 ? NumberUtil.RGB(255, 255, 255) : NumberUtil.RGB(255, 223, 0), RenderUtil.StringRenderType.OUTLINED);
            }
        } else if (Keybinds.statusSkillGuiMessage && Keybinds.keySkillGui.getKey().func_197937_c() != -1) {
            RenderUtil.drawCenteredScaledString(mc.field_71466_p, LocaleUtil.getLocaleString("gui.aoa3.skills.showtip", Keybinds.keySkillGui.func_197978_k()), rootX + 228, rootY + 2, 1.5f, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
        }
    }

    private static int getPotionGuiRenderOffset(Minecraft mc) {
        if (mc.field_71439_g.func_70651_bq().isEmpty() || ((Boolean)AoAConfig.CLIENT.disableHudPotionOffset.get()).booleanValue()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (EffectInstance effect : mc.field_71439_g.func_70651_bq()) {
            if (effect.func_76459_b() <= 0 || !effect.func_188419_a().shouldRenderHUD(effect) || !effect.func_188418_e()) continue;
            if (!effect.func_188419_a().func_188408_i()) {
                effectRenderYOffset = 100;
                break;
            }
            effectRenderYOffset = 50;
        }
        return effectRenderYOffset;
    }
}

