/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.constant.Skills;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT})
public class XpParticlesRenderer {
    private static final ConcurrentHashMap<Skills, CopyOnWriteArrayList<XPParticle>> particlesMap = new ConcurrentHashMap(15);
    private static final ResourceLocation skillsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/skills.png");
    private static long lastPacketReceivedTime = 0L;
    private static XPParticle lastParticleReceived = null;
    private static Skills lastParticleSkill = null;

    public static void addXpParticle(Skills skill, float xp, boolean isLevelUp) {
        XPParticle particle;
        if (!particlesMap.containsKey((Object)skill)) {
            particlesMap.put(skill, new CopyOnWriteArrayList());
        }
        if (lastParticleSkill == skill && System.currentTimeMillis() <= lastPacketReceivedTime + 10L && lastParticleReceived != null) {
            lastParticleReceived.modifyXp(xp, isLevelUp);
            if (XpParticlesRenderer.lastParticleReceived.levelUp) {
                CopyOnWriteArrayList<XPParticle> array = particlesMap.get((Object)skill);
                if (array.size() > 0) {
                    array.remove(array.size() - 1);
                }
                array.add(0, lastParticleReceived);
            }
            return;
        }
        if (isLevelUp) {
            particle = new XPParticle(xp, true);
            particlesMap.get((Object)skill).add(0, particle);
        } else {
            particle = new XPParticle(xp, false);
            particlesMap.get((Object)skill).add(particle);
        }
        lastParticleReceived = particle;
        lastPacketReceivedTime = System.currentTimeMillis();
        lastParticleSkill = skill;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END || particlesMap.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        if (((Boolean)AoAConfig.CLIENT.showXpParticles.get()).booleanValue()) {
            if (mc.field_71462_r == null && !mc.field_71474_y.field_74319_N) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableAlphaTest();
                long currentTime = System.currentTimeMillis();
                Iterator<Map.Entry<Skills, CopyOnWriteArrayList<XPParticle>>> mapIterator = particlesMap.entrySet().iterator();
                int skillCount = particlesMap.size();
                int scrollHeight = (int)((float)window.func_198087_p() / 3.0f);
                int skillNum = 0;
                float rowBasedScale = (int)(1.0f + (float)(skillCount - 1) / 5.0f);
                float renderSize = 25.0f / (1.0f + (rowBasedScale - 1.0f) * 0.5f);
                double skillIconsX = (double)((float)window.func_198107_o() - renderSize * (1.0f + (float)(Math.min(skillCount, 5) - 1) * 0.5f)) / 2.0;
                double skillIconsY = 2.0;
                while (mapIterator.hasNext()) {
                    Map.Entry<Skills, CopyOnWriteArrayList<XPParticle>> particleEntry = mapIterator.next();
                    Skills skill = particleEntry.getKey();
                    CopyOnWriteArrayList<XPParticle> particleArray = particleEntry.getValue();
                    if (particleArray.isEmpty()) {
                        mapIterator.remove();
                        continue;
                    }
                    boolean isLevelUp = particleArray.get((int)0).levelUp;
                    ArrayList<XPParticle> removalList = null;
                    for (XPParticle particle2 : particleArray) {
                        float particleLifespan = 1.0f - (float)(currentTime - particle2.creationTime) / 1500.0f;
                        if ((double)particleLifespan >= 0.1) {
                            RenderUtil.drawCenteredScaledString(mc.field_71466_p, particle2.xpString, (int)((double)window.func_198107_o() / 2.0), (int)((float)scrollHeight * particleLifespan), 0.5f, NumberUtil.RGB(255, 255, 255) | (int)MathHelper.func_76131_a((float)(255.0f * particleLifespan), (float)1.0f, (float)255.0f) << 24, RenderUtil.StringRenderType.NORMAL);
                        }
                        if (particle2.creationTime > currentTime - 1800L) continue;
                        if (removalList == null) {
                            removalList = new ArrayList<XPParticle>();
                        }
                        removalList.add(particle2);
                    }
                    int skillUvX = 0;
                    int skillUvY = isLevelUp ? 50 : 0;
                    switch (skill) {
                        case ALCHEMY: {
                            break;
                        }
                        case ANIMA: {
                            skillUvX = 50;
                            break;
                        }
                        case AUGURY: {
                            skillUvX = 100;
                            break;
                        }
                        case BUTCHERY: {
                            skillUvX = 150;
                            break;
                        }
                        case CREATION: {
                            skillUvX = 200;
                            break;
                        }
                        case ENGINEERING: {
                            skillUvX = 250;
                            break;
                        }
                        case EXPEDITION: {
                            skillUvX = 300;
                            break;
                        }
                        case EXTRACTION: {
                            skillUvX = 350;
                            break;
                        }
                        case FORAGING: {
                            skillUvX = 400;
                            break;
                        }
                        case HAULING: {
                            skillUvY += 100;
                            break;
                        }
                        case HUNTER: {
                            skillUvX = 50;
                            skillUvY += 100;
                            break;
                        }
                        case INFUSION: {
                            skillUvX = 100;
                            skillUvY += 100;
                            break;
                        }
                        case INNERVATION: {
                            skillUvX = 150;
                            skillUvY += 100;
                            break;
                        }
                        case LOGGING: {
                            skillUvX = 200;
                            skillUvY += 100;
                            break;
                        }
                        case RUNATION: {
                            skillUvX = 250;
                            skillUvY += 100;
                        }
                    }
                    double newX = skillIconsX + (double)((float)(skillNum % 5) * renderSize * 0.5f);
                    double newY = 2.0 + (double)((float)(skillNum / 5) * renderSize * 0.5f);
                    mc.func_110434_K().func_110577_a(skillsTextures);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.renderScaledCustomSizedTexture(newX, newY, skillUvX, skillUvY, 50.0f, 50.0f, renderSize, renderSize, 450.0f, 240.0f);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (isLevelUp) {
                        String lvl = String.valueOf(AdventGuiTabPlayer.getSkillLevel(skill));
                        float stringScale = Math.min(1.4f, 16.8f / (float)mc.field_71466_p.func_78256_a(lvl)) / rowBasedScale;
                        FontRenderer fontRenderer = mc.field_71466_p;
                        int n = (int)(newX + (double)((renderSize + 2.0f) / 2.0f));
                        double d = newY + (double)(renderSize / 2.0f);
                        mc.field_71466_p.getClass();
                        RenderUtil.drawCenteredScaledString(fontRenderer, lvl, n, (int)(d - (double)(9.0f / 3.0f * stringScale)), stringScale, NumberUtil.RGB(255, 255, 255), RenderUtil.StringRenderType.OUTLINED);
                    }
                    if (removalList != null) {
                        particleArray.removeAll(removalList);
                    }
                    if (particleArray.isEmpty()) {
                        mapIterator.remove();
                    }
                    ++skillNum;
                }
                RenderSystem.enableDepthTest();
                RenderSystem.disableAlphaTest();
            } else if (!particlesMap.isEmpty()) {
                Iterator<Map.Entry<Skills, CopyOnWriteArrayList<XPParticle>>> mapIterator = particlesMap.entrySet().iterator();
                long cutoffTime = System.currentTimeMillis() - 1800L;
                while (mapIterator.hasNext()) {
                    CopyOnWriteArrayList<XPParticle> particleArray = mapIterator.next().getValue();
                    particleArray.removeIf(particle -> particle.creationTime <= cutoffTime);
                    if (!particleArray.isEmpty()) continue;
                    mapIterator.remove();
                }
            }
        } else if (!particlesMap.isEmpty()) {
            particlesMap.clear();
        }
    }

    private static String getAprilFoolsXpString() {
        return RandomUtil.getRandomSelection("Nice!", "69xp", "420xp", "-1xp", "422180734982xp", "Xp Get!", "GAINSSS", "5xp maybe?", "\u00e2\u0152\u02c6(\u00e2\u0152\u02c61*50^1.3\u00e2\u0152\u2030/8+800)/46*37\u00e2\u0152\u2030+6xp", "?", "Where am I?");
    }

    static class XPParticle {
        boolean levelUp;
        float xp;
        String xpString;
        protected long creationTime = System.currentTimeMillis();

        XPParticle(float xp, boolean isLevelUp) {
            this.levelUp = isLevelUp;
            this.xp = xp;
            this.xpString = HolidayUtil.getCurrentHoliday() == HolidayUtil.Holiday.APRIL_FOOLS ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(xp, false);
        }

        protected void modifyXp(float additionalXp, boolean isLevelUp) {
            this.levelUp = this.levelUp || isLevelUp;
            this.xp += additionalXp;
            this.xpString = HolidayUtil.getCurrentHoliday() == HolidayUtil.Holiday.APRIL_FOOLS ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(this.xp, false);
        }
    }
}

