/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.util.constant.Skills;

public class LevelRequirementToast
implements IToast {
    private static final ResourceLocation skillsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/skills.png");
    private final Skills skill;
    private int iconUvX = 0;
    private int iconUvY = 0;
    private final int levelRequired;
    private final String title;
    private final String subtitle;

    public LevelRequirementToast(Skills relevantSkill, int levelRequirement) {
        this.skill = relevantSkill;
        this.levelRequired = levelRequirement;
        this.title = LocaleUtil.getLocaleString("gui.aoatoast.levelReq.title", TextFormatting.DARK_RED, new String[0]);
        this.subtitle = LocaleUtil.getLocaleString("gui.aoatoast.levelReq.subtitle", StringUtil.toSentenceCase(relevantSkill.toString()), String.valueOf(levelRequirement));
        this.applyIconUvs(relevantSkill);
    }

    public Skills getSkill() {
        return this.skill;
    }

    public int getLevelReq() {
        return this.levelRequired;
    }

    public IToast.Visibility func_193653_a(ToastGui toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.blit(0, 0, 0, 0, 160, 32);
        toastGui.func_192989_b().func_110434_K().func_110577_a(skillsTextures);
        RenderUtil.renderScaledCustomSizedTexture(6.0, 6.0, this.iconUvX, this.iconUvY, 50.0f, 50.0f, 20.0, 20.0, 450.0f, 240.0f);
        toastGui.func_192989_b().field_71466_p.func_211126_b(this.title, 30.0f, 7.0f, -11534256);
        toastGui.func_192989_b().field_71466_p.func_211126_b(this.subtitle, 30.0f, 18.0f, NumberUtil.RGB(255, 255, 255));
        return delta >= 3000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    private void applyIconUvs(Skills skill) {
        switch (skill) {
            case ALCHEMY: {
                this.iconUvX = 0;
                this.iconUvY = 0;
                break;
            }
            case ANIMA: {
                this.iconUvX = 50;
                this.iconUvY = 0;
                break;
            }
            case AUGURY: {
                this.iconUvX = 100;
                this.iconUvY = 0;
                break;
            }
            case BUTCHERY: {
                this.iconUvX = 150;
                this.iconUvY = 0;
                break;
            }
            case CREATION: {
                this.iconUvX = 200;
                this.iconUvY = 0;
                break;
            }
            case ENGINEERING: {
                this.iconUvX = 250;
                this.iconUvY = 0;
                break;
            }
            case EXPEDITION: {
                this.iconUvX = 300;
                this.iconUvY = 0;
                break;
            }
            case EXTRACTION: {
                this.iconUvX = 350;
                this.iconUvY = 0;
                break;
            }
            case FORAGING: {
                this.iconUvX = 400;
                this.iconUvY = 0;
                break;
            }
            case HAULING: {
                this.iconUvX = 0;
                this.iconUvY = 100;
                break;
            }
            case HUNTER: {
                this.iconUvX = 50;
                this.iconUvY = 100;
                break;
            }
            case INFUSION: {
                this.iconUvX = 100;
                this.iconUvY = 100;
                break;
            }
            case INNERVATION: {
                this.iconUvX = 150;
                this.iconUvY = 100;
                break;
            }
            case LOGGING: {
                this.iconUvX = 200;
                this.iconUvY = 100;
                break;
            }
            case RUNATION: {
                this.iconUvX = 250;
                this.iconUvY = 100;
            }
        }
    }
}

