/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.util.constant.Resources;

public class ResourceRequirementToast
implements IToast {
    private static final ResourceLocation resourcesTextures = new ResourceLocation("aoa3", "textures/gui/maingui/resources.png");
    private final Resources resource;
    private int iconUvX = 0;
    private int iconUvY = 0;
    private final float resourceAmount;
    private final String title;
    private final String subtitle;

    public ResourceRequirementToast(Resources relevantResource, float resourceRequirement) {
        this.resource = relevantResource;
        this.resourceAmount = resourceRequirement;
        this.title = LocaleUtil.getLocaleString("gui.aoatoast.resourceReq.title", TextFormatting.DARK_RED, new String[0]);
        this.subtitle = LocaleUtil.getLocaleString("gui.aoatoast.resourceReq.subtitle", StringUtil.toSentenceCase(relevantResource.toString()), NumberUtil.roundToNthDecimalPlace(resourceRequirement, 2));
        this.applyIconUvs(relevantResource);
    }

    public Resources getResource() {
        return this.resource;
    }

    public float getAmountRequired() {
        return this.resourceAmount;
    }

    public IToast.Visibility func_193653_a(ToastGui toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.blit(0, 0, 0, 0, 160, 32);
        toastGui.func_192989_b().func_110434_K().func_110577_a(resourcesTextures);
        RenderUtil.renderScaledCustomSizedTexture(6.0, 6.0, this.iconUvX, this.iconUvY, 50.0f, 50.0f, 20.0, 20.0, 400.0f, 590.0f);
        toastGui.func_192989_b().field_71466_p.func_211126_b(this.title, 30.0f, 7.0f, -11534256);
        toastGui.func_192989_b().field_71466_p.func_211126_b(this.subtitle, 30.0f, 18.0f, NumberUtil.RGB(255, 255, 255));
        return delta >= 3000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    private void applyIconUvs(Resources skill) {
        switch (skill) {
            case CREATION: {
                this.iconUvX = 0;
                this.iconUvY = 340;
                break;
            }
            case ENERGY: {
                this.iconUvX = 0;
                this.iconUvY = 140;
                break;
            }
            case RAGE: {
                this.iconUvX = 0;
                this.iconUvY = 50;
                break;
            }
            case SOUL: {
                this.iconUvX = 0;
                this.iconUvY = 440;
            }
        }
    }
}

