/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.lib;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class ScrollablePane {
    private Minecraft mc;
    protected int top;
    protected int bottom;
    protected int left;
    protected int right;
    protected int viewWidth;
    protected int viewHeight;
    protected int scrollBarHeight;
    private float currentRenderScale;
    protected int mouseX;
    protected int mouseY;
    private boolean mouseFocussed;
    protected boolean isDragging = false;
    private float mouseYPosState = -2.0f;
    protected float distanceScrolled;
    private float scrollFactor;

    public ScrollablePane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... renderingScale) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
        if (renderingScale.length > 0) {
            this.currentRenderScale = renderingScale[0];
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int scrollBarWidth = 6;
        this.mouseFocussed = this.isMouseHovering();
        int paneHeight = this.getFullPaneHeight();
        int paneViewDiff = paneHeight - this.viewHeight;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        if (paneViewDiff > 0) {
            this.scrollBarHeight = (int)MathHelper.func_76131_a((float)((float)(this.viewHeight * this.viewHeight) / (float)paneHeight), (float)32.0f, (float)this.viewHeight);
        }
        if (this.isDragging) {
            if (this.mouseYPosState == -1.0f) {
                if (this.mouseFocussed) {
                    if (mouseX >= this.right - scrollBarWidth && mouseX <= this.right) {
                        this.scrollFactor = -1.0f;
                        int scrollHeight = Math.max(paneHeight - this.viewHeight, 1);
                        this.scrollFactor /= (float)(this.viewHeight - this.scrollBarHeight) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.mouseYPosState = mouseY;
                } else {
                    this.mouseYPosState = -2.0f;
                }
            } else if (this.mouseYPosState >= 0.0f) {
                this.distanceScrolled -= ((float)mouseY - this.mouseYPosState) * this.scrollFactor;
                this.mouseYPosState = mouseY;
            }
        } else {
            this.mouseYPosState = -1.0f;
        }
        this.distanceScrolled = MathHelper.func_76131_a((float)this.distanceScrolled, (float)0.0f, (float)(paneHeight - this.viewHeight));
        GL11.glEnable((int)3089);
        MainWindow mcWindow = this.mc.func_228018_at_();
        float windowWidthScale = this.currentRenderScale * ((float)mcWindow.func_198105_m() / (float)mcWindow.func_198107_o());
        float windowHeightScale = this.currentRenderScale * ((float)mcWindow.func_198083_n() / (float)mcWindow.func_198087_p());
        GL11.glScissor((int)((int)(((double)this.left - 1.5) * (double)windowWidthScale)), (int)((int)(((float)mcWindow.func_198083_n() / windowHeightScale - (float)this.bottom) * windowHeightScale)), (int)((int)((float)(this.viewWidth + 3) * windowWidthScale)), (int)((int)(((double)this.viewHeight + 1.5) * (double)windowHeightScale)));
        this.drawBackground();
        GuiUtils.drawGradientRect((int)0, (int)(this.left - 1), (int)(this.top - 1), (int)(this.right + 1), (int)(this.bottom + 1), (int)-1072689136, (int)-804253680);
        int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
        this.drawPaneContents(newTop, this.left, this.right, this.bottom, this.distanceScrolled, partialTicks);
        RenderSystem.disableDepthTest();
        if (paneViewDiff > 0) {
            int barTop = Math.max((int)this.distanceScrolled * (this.viewHeight - this.scrollBarHeight) / paneViewDiff + this.top, this.top);
            int barLeft = this.right - 6;
            RenderSystem.disableTexture();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)barLeft, (double)this.bottom, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)(this.right + 1), (double)this.bottom, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)(this.right + 1), (double)this.top, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)barLeft, (double)this.top, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)barLeft, (double)(barTop + this.scrollBarHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)(this.right + 1), (double)(barTop + this.scrollBarHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)(this.right + 1), (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)barLeft, (double)(barTop + this.scrollBarHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)this.right, (double)(barTop + this.scrollBarHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)this.right, (double)barTop, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)barLeft, (double)barTop, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    public void onResize(Minecraft mc, int left, int top, int viewWidth, int viewHeight) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewHeight = viewHeight;
        this.viewWidth = viewWidth;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        this.isDragging = true;
        return true;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return true;
    }

    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollAmount) {
        if (!this.mouseFocussed) {
            return false;
        }
        if (scrollAmount != 0.0) {
            this.distanceScrolled = (float)((double)this.distanceScrolled + -20.0 * scrollAmount);
        }
        return true;
    }

    private boolean isMouseHovering() {
        return this.mouseX >= this.left && this.mouseX <= this.right && this.mouseY >= this.top && this.mouseY <= this.bottom;
    }

    public abstract int getFullPaneHeight();

    public abstract void drawPaneContents(int var1, int var2, int var3, int var4, float var5, float var6);

    public abstract void drawBackground();
}

