/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.realmstone;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

public class BlankRealmstoneScreen
extends Screen {
    private static final ResourceLocation background = new ResourceLocation("aoa3", "textures/gui/realmstonegui/background.png");
    private static final ResourceLocation windowFrame = new ResourceLocation("aoa3", "textures/gui/realmstonegui/window_frame.png");
    private static final int backgroundHeight = 1515;
    private static final int backgroundWidth = 1889;
    private static final int viewSpaceWidth = 234;
    private static final int viewSpaceHeight = 155;
    private static float scale = 0.5f;
    private final ArrayList<RealmstoneWorldInsert> worldInserts = new ArrayList(23);
    private static RealmstoneWorldInsert currentlyHoveredInsert = null;
    private boolean isPanning = false;
    private int panMouseX = 0;
    private int panMouseY = 0;
    private int offsetX = 643;
    private int offsetY = 590;

    public BlankRealmstoneScreen() {
        super((ITextComponent)LocaleUtil.getLocaleMessage("gui.aoa3.realmstone.title"));
        scale = 0.5f;
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.abyss", "gui.realmstoneMenu.hover.abyss", 1228, 694, 100, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.ancient_cavern", "gui.realmstoneMenu.hover.ancient_cavern", 727, 1295, 300, 300));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.barathos", "gui.realmstoneMenu.hover.barathos", 627, 895, 400, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.candyland", "gui.realmstoneMenu.hover.candyland", 427, 595, 200, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.celeve", "gui.realmstoneMenu.hover.celeve", 1252, 970, 500, 300));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.creeponia", "gui.realmstoneMenu.hover.creeponia", 827, 495, 0, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.crystevia", "gui.realmstoneMenu.hover.crystevia", 827, 1095, 300, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.deeplands", "gui.realmstoneMenu.hover.deeplands", 827, 895, 300, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.dustopia", "gui.realmstoneMenu.hover.dustopia", 1428, 795, 100, 400));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.gardencia", "gui.realmstoneMenu.hover.gardencia", 427, 795, 200, 300));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.greckon", "gui.realmstoneMenu.hover.greckon", 1428, 595, 100, 300));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.haven", "gui.realmstoneMenu.hover.haven", 1102, 1120, 500, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.immortallis", "gui.realmstoneMenu.hover.immortallis", 927, 1295, 300, 400));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.iromine", "gui.realmstoneMenu.hover.iromine", 427, 1095, 400, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.lborean", "gui.realmstoneMenu.hover.lborean", 227, 695, 200, 400));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.lelyetia", "gui.realmstoneMenu.hover.lelyetia", 1027, 895, 500, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.lunalus", "gui.realmstoneMenu.hover.lunalus", 1327, 1195, 500, 400));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.mysterium", "gui.realmstoneMenu.hover.mysterium", 927, 295, 0, 200));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.nether", "gui.realmstoneMenu.hover.nether", 1027, 695, 100, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.overworld", "gui.realmstoneMenu.hover.overworld", 827, 695, 200, 0));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.precasia", "gui.realmstoneMenu.hover.precasia", 627, 695, 200, 100));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.runandor", "gui.realmstoneMenu.hover.runandor", 827, 95, 0, 400));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.shyrelands", "gui.realmstoneMenu.hover.shyrelands", 1628, 695, 100, 500));
        this.worldInserts.add(new RealmstoneWorldInsert("dimension.aoa3.vox_ponds", "gui.realmstoneMenu.hover.vox_ponds", 727, 295, 0, 300));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        int x = (this.width - 252) / 2;
        int y = (this.height - 182) / 2;
        currentlyHoveredInsert = null;
        if (this.isDragging()) {
            if (!this.isPanning) {
                this.panMouseX = mouseX;
                this.panMouseY = mouseY;
            }
            this.isPanning = true;
            this.offsetX = MathHelper.func_76125_a((int)(this.offsetX + (int)((float)(this.panMouseX - mouseX) / scale)), (int)0, (int)(1889 - (int)(234.0f / scale)));
            this.offsetY = MathHelper.func_76125_a((int)(this.offsetY + (int)((float)(this.panMouseY - mouseY) / scale)), (int)0, (int)(1515 - (int)(155.0f / scale)));
            this.panMouseX = mouseX;
            this.panMouseY = mouseY;
        } else {
            this.isPanning = false;
            this.panMouseX = 0;
            this.panMouseY = 0;
        }
        this.renderBackground();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.minecraft.func_110434_K().func_110577_a(background);
        RenderUtil.renderCustomSizedTexture((int)((float)(x + 9) / scale), (int)((float)(y + 18) / scale), this.offsetX, this.offsetY, (int)(234.0f / scale), (int)(155.0f / scale), 1889.0f, 1515.0f);
        for (RealmstoneWorldInsert insert : this.worldInserts) {
            insert.render(this.minecraft, (int)((float)(x + 9) / BlankRealmstoneScreen.scale), (int)((float)(y + 18) / BlankRealmstoneScreen.scale), this.offsetX, this.offsetY, (int)((float)mouseX / BlankRealmstoneScreen.scale), (int)((float)mouseY / BlankRealmstoneScreen.scale));
        }
        RenderSystem.popMatrix();
        this.drawWindowFrame(x, y);
        if (currentlyHoveredInsert != null && !BlankRealmstoneScreen.currentlyHoveredInsert.getHoverTexts().isEmpty()) {
            this.renderTooltip(BlankRealmstoneScreen.currentlyHoveredInsert.getHoverTexts(), mouseX, mouseY);
        }
    }

    private void drawWindowFrame(int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderHelper.func_74518_a();
        this.minecraft.func_110434_K().func_110577_a(windowFrame);
        RenderUtil.renderCustomSizedTexture(x, y, 0.0f, 0.0f, 256, 187, 256.0f, 256.0f);
        this.minecraft.field_71466_p.func_211126_b(this.title.func_150254_d(), (float)(x + 8), (float)(y + 6), NumberUtil.RGB(181, 181, 181));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int left = (this.width - 252) / 2;
        int bottom = (this.height - 182) / 2;
        if (mouseX >= (double)left && mouseX <= (double)(left + 252) && mouseY >= (double)bottom && mouseY <= (double)(bottom + 182)) {
            this.setDragging(true);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        scale = (float)((double)scale + scrollAmount / 100.0);
        scale = (float)MathHelper.func_151237_a((double)scale, (double)0.14, (double)1.3);
        this.offsetX = Math.min(this.offsetX, 1889 - (int)(234.0f / scale));
        this.offsetY = Math.min(this.offsetY, 1515 - (int)(155.0f / scale));
        return true;
    }

    private static class RealmstoneWorldInsert {
        private static final ResourceLocation worldImages = new ResourceLocation("aoa3", "textures/gui/realmstonegui/world_images.png");
        private static final int iconSize = 100;
        private final int uvX;
        private final int uvY;
        private final int posX;
        private final int posY;
        private final ArrayList<String> hoverTexts = new ArrayList(2);

        private RealmstoneWorldInsert(String worldNameKey, @Nullable String hoverTextKey, int posX, int posY, int uvX, int uvY) {
            this.hoverTexts.add(LocaleUtil.getLocaleString(worldNameKey, TextFormatting.BLUE, new String[0]));
            if (hoverTextKey != null) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                this.hoverTexts.addAll(fontRenderer.func_78271_c(LocaleUtil.getLocaleString(hoverTextKey), 200));
            }
            this.posX = posX;
            this.posY = posY;
            this.uvX = uvX;
            this.uvY = uvY;
        }

        private void render(Minecraft mc, int baseX, int baseY, int scrollX, int scrollY, int mouseX, int mouseY) {
            int renderX = baseX + this.posX - scrollX;
            int renderY = baseY + this.posY - scrollY;
            int overlapLeft = MathHelper.func_76125_a((int)(baseX - renderX), (int)0, (int)100);
            if (overlapLeft >= 100) {
                return;
            }
            int overlapTop = MathHelper.func_76125_a((int)(baseY - renderY), (int)0, (int)100);
            if (overlapTop >= 100) {
                return;
            }
            int overlapRight = MathHelper.func_76125_a((int)(renderX + 100 - (baseX + (int)(234.0f / scale))), (int)0, (int)100);
            if (overlapRight >= 100) {
                return;
            }
            int overlapBottom = MathHelper.func_76125_a((int)(renderY + 100 - (baseY + (int)(155.0f / scale))), (int)0, (int)100);
            if (overlapBottom >= 100) {
                return;
            }
            int width = 100 - overlapLeft - overlapRight;
            int height = 100 - overlapTop - overlapBottom;
            GlStateManager.func_227740_m_();
            mc.func_110434_K().func_110577_a(worldImages);
            RenderUtil.renderCustomSizedTexture(renderX += overlapLeft, renderY += overlapTop, this.uvX + overlapLeft, this.uvY + overlapTop, width, height, 1000.0f, 1000.0f);
            RenderUtil.renderCustomSizedTexture(renderX, renderY, overlapLeft, overlapTop, width, height, 1000.0f, 1000.0f);
            GlStateManager.func_227737_l_();
            if (currentlyHoveredInsert == null && mouseX > renderX + 5 && mouseX < renderX + width - 5 && mouseY > renderY + 5 && mouseY < renderY + height - 5) {
                currentlyHoveredInsert = this;
            }
        }

        private ArrayList<String> getHoverTexts() {
            return this.hoverTexts;
        }
    }
}

