/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.world.World;
import net.tslat.aoa3.library.misc.CustomisableParticleType;

public class PortalFloaterParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite sprite;
    private final double originPosX;
    private final double originPosY;
    private final double originPosZ;

    public PortalFloaterParticle(World world, double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, IAnimatedSprite sprite, float scale, float ageModifier, float red, float green, float blue, float alpha) {
        super(world, posX, posY, posZ, velocityX, velocityY, velocityZ);
        this.sprite = sprite;
        this.originPosX = posX;
        this.originPosY = posY;
        this.originPosZ = posZ;
        this.field_187129_i = velocityX;
        this.field_187130_j = velocityY;
        this.field_187131_k = velocityZ;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_82339_as = alpha;
        this.field_70544_f = scale * this.field_187136_p.nextFloat() * 0.07f;
        this.field_70547_e = (int)((Math.random() * 10.0 + 40.0) * (double)ageModifier);
        this.func_217568_a(this.sprite);
    }

    public float func_217561_b(float scaleFactor) {
        float scale = 1.0f - ((float)this.field_70546_d + scaleFactor) / (float)this.field_70547_e;
        scale = 1.0f - scale * scale;
        return this.field_70544_f * scale;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_189213_a() {
        float percentAged = (float)this.field_70546_d / (float)this.field_70547_e;
        float ageModifier = 1.0f - (-percentAged + percentAged * percentAged * 2.0f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187126_f = this.originPosX + this.field_187129_i * (double)ageModifier;
        this.field_187127_g = this.originPosY + this.field_187130_j * (double)ageModifier + (double)(1.0f - percentAged);
        this.field_187128_h = this.originPosZ + this.field_187131_k * (double)ageModifier;
        this.func_217566_b(this.sprite);
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public int func_189214_a(float p_189214_1_) {
        int initialBrightness = super.func_189214_a(p_189214_1_);
        double percentAged = Math.pow((float)this.field_70546_d / (float)this.field_70547_e, 3.0);
        int brightnessLowerBits = initialBrightness & 0xFF;
        int brightnessUpperBits = initialBrightness >> 16 & 0xFF;
        brightnessUpperBits = Math.min(brightnessUpperBits + (int)(percentAged * 240.0), 240);
        return brightnessLowerBits | brightnessUpperBits << 16;
    }

    public static class Factory
    implements IParticleFactory<CustomisableParticleType.Data> {
        private final IAnimatedSprite sprite;

        public Factory(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle makeParticle(CustomisableParticleType.Data data, World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new PortalFloaterParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprite, data.scale, data.ageModifier, data.red, data.green, data.blue, data.alpha);
        }
    }
}

