/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.tslat.aoa3.client.model.entity.misc.PlayerHaloModel;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.library.misc.AoAHalos;

public class PlayerHaloRenderLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aoa3", "textures/entities/player/halo_texture.png");
    private static final PlayerHaloModel MODEL = new PlayerHaloModel();
    private final PlayerRenderer renderer;

    public PlayerHaloRenderLayer(PlayerRenderer playerRenderer) {
        super((IEntityRenderer)playerRenderer);
        this.renderer = playerRenderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLightIn, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (player.func_152122_n() && !player.func_82150_aj() && ((Boolean)AoAConfig.CLIENT.showPlayerHalos.get()).booleanValue()) {
            AoAHalos.Type chosenHalo = AoAHalos.getHalo(player.func_110124_au());
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (chosenHalo == null) {
                return;
            }
            switch (chosenHalo) {
                case Donator: {
                    red = 1.0f;
                    green = 1.0f;
                    break;
                }
                case Super_Donator: 
                case Crazy_Donator: {
                    red = 1.0f;
                    break;
                }
                case Tslat: {
                    red = 0.1647f;
                    green = 1.0f;
                    break;
                }
                case Staff: {
                    red = 0.6f;
                    green = 1.0f;
                    blue = 1.0f;
                    break;
                }
                case Wiki_Editor: {
                    blue = 1.0f;
                }
            }
            this.getEntityModel().halo.func_217177_a(((PlayerModel)this.renderer.func_217764_d()).field_78116_c);
            IVertexBuilder vertexBuilder = buffer.getBuffer(PlayerHaloRenderLayer.getRenderType(this.getEntityTexture(player)));
            this.getEntityModel().func_225598_a_(matrix, vertexBuilder, 0xF00000, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
        }
    }

    public PlayerHaloModel getEntityModel() {
        return MODEL;
    }

    protected ResourceLocation getEntityTexture(AbstractClientPlayerEntity entityIn) {
        return TEXTURE;
    }

    private static RenderType getRenderType(ResourceLocation texture) {
        RenderState.TextureState renderState = new RenderState.TextureState(texture, false, false);
        RenderState.TransparencyState transparencyState = new RenderState.TransparencyState("additive_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        RenderState.FogState fogState = new RenderState.FogState("black_fog", () -> {
            RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.enableFog();
        }, () -> {
            FogRenderer.func_228373_b_();
            RenderSystem.disableFog();
        });
        return RenderType.func_228633_a_((String)"halo", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(renderState).func_228726_a_(transparencyState).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228715_a_(new RenderState.DepthTestState(515)).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228717_a_(fogState).func_228728_a_(false));
    }
}

