/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.minion;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.client.render.entity.layer.FriendlyCreeperChargeRenderLayer;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.minion.FriendlyCreeperEntity;

public class FriendlyCreeperRenderer
extends LivingRenderer<MobEntity, EntityModel<MobEntity>> {
    private static final ResourceLocation textures = new ResourceLocation("minecraft", "textures/entity/creeper/creeper.png");

    public FriendlyCreeperRenderer(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new CreeperModel(), ((EntityType)AoAEntities.Minions.FRIENDLY_CREEPER.get()).func_220333_h() / 3.0f);
        this.func_177094_a(new FriendlyCreeperChargeRenderLayer(this, (EntityModel<MobEntity>)new CreeperModel(2.0f)));
    }

    protected void preRenderCallback(MobEntity entity, MatrixStack matrix, float partialTicks) {
        float flashIntensity = ((FriendlyCreeperEntity)entity).getCreeperFlashIntensity(partialTicks);
        float scaleRotationMod = 1.0f + MathHelper.func_76126_a((float)(flashIntensity * 100.0f)) * flashIntensity * 0.01f;
        flashIntensity = (float)Math.pow(MathHelper.func_76131_a((float)flashIntensity, (float)0.0f, (float)1.0f), 3.0);
        float scaleHorizontal = (1.0f + flashIntensity * 0.4f) * scaleRotationMod;
        float scaleVertical = (1.0f + flashIntensity * 0.1f) / scaleRotationMod;
        matrix.func_227862_a_(scaleHorizontal, scaleVertical, scaleHorizontal);
    }

    protected float getOverlayProgress(MobEntity entity, float partialTicks) {
        float flashIntensity = ((FriendlyCreeperEntity)entity).getCreeperFlashIntensity(partialTicks);
        return (int)(flashIntensity * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)flashIntensity, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(MobEntity entity) {
        return textures;
    }
}

