/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.client.model.entity.misc.AnimaStoneModel;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.entity.misc.AnimaStoneEntity;
import net.tslat.aoa3.library.misc.CustomisableParticleType;
import net.tslat.aoa3.util.NumberUtil;

public class AnimaStoneRenderer
extends EntityRenderer<AnimaStoneEntity> {
    private final ResourceLocation texture = new ResourceLocation("aoa3", "textures/entities/misc/anima_stone.png");
    private final EntityModel<Entity> model = new AnimaStoneModel();

    public AnimaStoneRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(AnimaStoneEntity entity, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float pitch = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        this.model.func_212843_a_((Entity)entity, 0.0f, 0.0f, partialTicks);
        this.model.func_225597_a_((Entity)entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, pitch);
        matrix.func_227861_a_(0.0, -1.5, 0.0);
        boolean visible = !entity.func_82150_aj();
        boolean shade = !visible && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        RenderType rendertype = this.getRenderType(entity, visible, shade);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(rendertype);
            this.model.func_225598_a_(matrix, ivertexbuilder, packedLight, NumberUtil.RGB(255, 255, 255), 1.0f, 1.0f, 1.0f, shade ? 0.15f : 1.0f);
            entity.field_70170_p.func_195594_a((IParticleData)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FLICKERING_SPARKLER.get()), 0.1f, 3.0f, NumberUtil.RGB(0, 255, 255)), entity.func_226277_ct_(), entity.func_226278_cu_() + (double)0.3f, entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        matrix.func_227865_b_();
        super.func_225623_a_((Entity)entity, yaw, partialTicks, matrix, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(AnimaStoneEntity entity, boolean visible, boolean shade) {
        ResourceLocation texture = this.getEntityTexture(entity);
        if (shade) {
            return RenderType.func_228644_e_((ResourceLocation)texture);
        }
        if (visible) {
            return this.model.func_228282_a_(texture);
        }
        return entity.func_225510_bt_() ? RenderType.func_228654_j_((ResourceLocation)texture) : null;
    }

    @Nullable
    public ResourceLocation getEntityTexture(AnimaStoneEntity entity) {
        return this.texture;
    }
}

